/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.crypto.CryptoPermissions;

final class JarVerifier {
    private URL jarURL;
    private boolean savePerms;
    private CryptoPermissions appPerms = null;

    JarVerifier(URL jarURL, boolean savePerms) {
        this.jarURL = jarURL;
        this.savePerms = savePerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verify() throws JarException, IOException {
        block10: {
            if (!this.savePerms) {
                return;
            }
            final URL url = this.jarURL.getProtocol().equalsIgnoreCase("jar") ? this.jarURL : new URL("jar:" + this.jarURL.toString() + "!/");
            try (ZipFile jf = null;){
                try {
                    jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            JarURLConnection conn = (JarURLConnection)url.openConnection();
                            conn.setUseCaches(false);
                            return conn.getJarFile();
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    SecurityException se = new SecurityException("Cannot load " + url.toString());
                    se.initCause(pae);
                    throw se;
                }
                if (jf == null) break block10;
                JarEntry je = ((JarFile)jf).getJarEntry("cryptoPerms");
                if (je == null) {
                    throw new JarException("Can not find cryptoPerms");
                }
                try {
                    this.appPerms = new CryptoPermissions();
                    this.appPerms.load(((JarFile)jf).getInputStream(je));
                }
                catch (Exception ex) {
                    JarException jex = new JarException("Cannot load/parse" + this.jarURL.toString());
                    jex.initCause(ex);
                    throw jex;
                }
            }
        }
    }

    static void verifyPolicySigned(Certificate[] certs) throws Exception {
    }

    CryptoPermissions getPermissions() {
        return this.appPerms;
    }
}

