/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import org.jcp.xml.dsig.internal.DigesterOutputStream;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMTransform;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMReference
extends DOMStructure
implements Reference,
DOMURIReference {
    public static final int MAXIMUM_TRANSFORM_COUNT = 5;
    private static boolean useC14N11 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.sun.org.apache.xml.internal.security.useC14N11");
        }
    });
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private final DigestMethod digestMethod;
    private final String id;
    private final List transforms;
    private List allTransforms;
    private final Data appliedTransformData;
    private Attr here;
    private final String uri;
    private final String type;
    private byte[] digestValue;
    private byte[] calcDigestValue;
    private Element refElem;
    private boolean digested = false;
    private boolean validated = false;
    private boolean validationStatus;
    private Data derefData;
    private InputStream dis;
    private MessageDigest md;
    private Provider provider;

    public DOMReference(String uri, String type, DigestMethod dm, List transforms, String id, Provider provider) {
        this(uri, type, dm, null, null, transforms, id, null, provider);
    }

    public DOMReference(String uri, String type, DigestMethod dm, List appliedTransforms, Data result, List transforms, String id, Provider provider) {
        this(uri, type, dm, appliedTransforms, result, transforms, id, null, provider);
    }

    public DOMReference(String uri, String type, DigestMethod dm, List appliedTransforms, Data result, List transforms, String id, byte[] digestValue, Provider provider) {
        int i;
        int size;
        ArrayList transformsCopy;
        if (dm == null) {
            throw new NullPointerException("DigestMethod must be non-null");
        }
        this.allTransforms = new ArrayList();
        if (appliedTransforms != null) {
            transformsCopy = new ArrayList(appliedTransforms);
            size = transformsCopy.size();
            for (i = 0; i < size; ++i) {
                if (transformsCopy.get(i) instanceof Transform) continue;
                throw new ClassCastException("appliedTransforms[" + i + "] is not a valid type");
            }
            this.allTransforms = transformsCopy;
        }
        if (transforms == null) {
            this.transforms = Collections.EMPTY_LIST;
        } else {
            transformsCopy = new ArrayList(transforms);
            size = transformsCopy.size();
            for (i = 0; i < size; ++i) {
                if (transformsCopy.get(i) instanceof Transform) continue;
                throw new ClassCastException("transforms[" + i + "] is not a valid type");
            }
            this.transforms = transformsCopy;
            this.allTransforms.addAll(transformsCopy);
        }
        this.digestMethod = dm;
        this.uri = uri;
        if (uri != null && !uri.equals("")) {
            try {
                new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.type = type;
        this.id = id;
        if (digestValue != null) {
            this.digestValue = (byte[])digestValue.clone();
            this.digested = true;
        }
        this.appliedTransformData = result;
        this.provider = provider;
    }

    public DOMReference(Element refElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        boolean secVal = Utils.secureValidation(context);
        Element nextSibling = DOMUtils.getFirstChildElement(refElem);
        ArrayList<DOMTransform> transforms = new ArrayList<DOMTransform>(5);
        if (nextSibling.getLocalName().equals("Transforms")) {
            Element transformElem = DOMUtils.getFirstChildElement(nextSibling);
            int transformCount = 0;
            while (transformElem != null) {
                transforms.add(new DOMTransform(transformElem, context, provider));
                transformElem = DOMUtils.getNextSiblingElement(transformElem);
                if (!secVal || ++transformCount <= 5) continue;
                String error = "A maxiumum of 5 transforms per Reference are allowed with secure validation";
                throw new MarshalException(error);
            }
            nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
        }
        Element dmElem = nextSibling;
        this.digestMethod = DOMDigestMethod.unmarshal(dmElem);
        String digestMethodAlgorithm = this.digestMethod.getAlgorithm();
        if (secVal && "http://www.w3.org/2001/04/xmldsig-more#md5".equals(digestMethodAlgorithm)) {
            throw new MarshalException("It is forbidden to use algorithm " + this.digestMethod + " when secure validation is enabled");
        }
        try {
            Element dvElem = DOMUtils.getNextSiblingElement(dmElem);
            this.digestValue = Base64.decode(dvElem);
        }
        catch (Base64DecodingException bde) {
            throw new MarshalException(bde);
        }
        this.uri = DOMUtils.getAttributeValue(refElem, "URI");
        Attr attr = refElem.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            this.id = attr.getValue();
            refElem.setIdAttributeNode(attr, true);
        } else {
            this.id = null;
        }
        this.type = DOMUtils.getAttributeValue(refElem, "Type");
        this.here = refElem.getAttributeNodeNS(null, "URI");
        this.refElem = refElem;
        this.transforms = transforms;
        this.allTransforms = transforms;
        this.appliedTransformData = null;
        this.provider = provider;
    }

    @Override
    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List getTransforms() {
        return Collections.unmodifiableList(this.allTransforms);
    }

    @Override
    public byte[] getDigestValue() {
        return this.digestValue == null ? null : (byte[])this.digestValue.clone();
    }

    @Override
    public byte[] getCalculatedDigestValue() {
        return this.calcDigestValue == null ? null : (byte[])this.calcDigestValue.clone();
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Marshalling Reference");
        }
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        this.refElem = DOMUtils.createElement(ownerDoc, "Reference", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttributeID(this.refElem, "Id", this.id);
        DOMUtils.setAttribute(this.refElem, "URI", this.uri);
        DOMUtils.setAttribute(this.refElem, "Type", this.type);
        if (!this.allTransforms.isEmpty()) {
            Element transformsElem = DOMUtils.createElement(ownerDoc, "Transforms", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
            this.refElem.appendChild(transformsElem);
            int size = this.allTransforms.size();
            for (int i = 0; i < size; ++i) {
                DOMStructure transform = (DOMStructure)this.allTransforms.get(i);
                transform.marshal(transformsElem, dsPrefix, context);
            }
        }
        ((DOMDigestMethod)this.digestMethod).marshal(this.refElem, dsPrefix, context);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Adding digestValueElem");
        }
        Element digestValueElem = DOMUtils.createElement(ownerDoc, "DigestValue", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        if (this.digestValue != null) {
            digestValueElem.appendChild(ownerDoc.createTextNode(Base64.encode(this.digestValue)));
        }
        this.refElem.appendChild(digestValueElem);
        parent.appendChild(this.refElem);
        this.here = this.refElem.getAttributeNodeNS(null, "URI");
    }

    public void digest(XMLSignContext signContext) throws XMLSignatureException {
        Element digestElem;
        Data data = null;
        data = this.appliedTransformData == null ? this.dereference(signContext) : this.appliedTransformData;
        this.digestValue = this.transform(data, signContext);
        String encodedDV = Base64.encode(this.digestValue);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Reference object uri = " + this.uri);
        }
        if ((digestElem = DOMUtils.getLastChildElement(this.refElem)) == null) {
            throw new XMLSignatureException("DigestValue element expected");
        }
        DOMUtils.removeAllChildren(digestElem);
        digestElem.appendChild(this.refElem.getOwnerDocument().createTextNode(encodedDV));
        this.digested = true;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Reference digesting completed");
        }
    }

    @Override
    public boolean validate(XMLValidateContext validateContext) throws XMLSignatureException {
        if (validateContext == null) {
            throw new NullPointerException("validateContext cannot be null");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        Data data = this.dereference(validateContext);
        this.calcDigestValue = this.transform(data, validateContext);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Expected digest: " + Base64.encode(this.digestValue));
            log.log(Level.FINE, "Actual digest: " + Base64.encode(this.calcDigestValue));
        }
        this.validationStatus = Arrays.equals(this.digestValue, this.calcDigestValue);
        this.validated = true;
        return this.validationStatus;
    }

    @Override
    public Data getDereferencedData() {
        return this.derefData;
    }

    @Override
    public InputStream getDigestInputStream() {
        return this.dis;
    }

    private Data dereference(XMLCryptoContext context) throws XMLSignatureException {
        Data data = null;
        URIDereferencer deref = context.getURIDereferencer();
        if (deref == null) {
            deref = DOMURIDereferencer.INSTANCE;
        }
        try {
            data = deref.dereference(this, context);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "URIDereferencer class name: " + deref.getClass().getName());
                log.log(Level.FINE, "Data class name: " + data.getClass().getName());
            }
        }
        catch (URIReferenceException ure) {
            throw new XMLSignatureException(ure);
        }
        return data;
    }

    private byte[] transform(Data dereferencedData, XMLCryptoContext context) throws XMLSignatureException {
        DigesterOutputStream dos;
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance(((DOMDigestMethod)this.digestMethod).getMessageDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new XMLSignatureException(nsae);
            }
        }
        this.md.reset();
        Boolean cache = (Boolean)context.getProperty("javax.xml.crypto.dsig.cacheReference");
        if (cache != null && cache.booleanValue()) {
            this.derefData = DOMReference.copyDerefData(dereferencedData);
            dos = new DigesterOutputStream(this.md, true);
        } else {
            dos = new DigesterOutputStream(this.md);
        }
        UnsyncBufferedOutputStream os = new UnsyncBufferedOutputStream(dos);
        Data data = dereferencedData;
        int size = this.transforms.size();
        for (int i = 0; i < size; ++i) {
            DOMTransform transform = (DOMTransform)this.transforms.get(i);
            try {
                if (i < size - 1) {
                    data = transform.transform(data, context);
                    continue;
                }
                data = transform.transform(data, context, os);
                continue;
            }
            catch (TransformException te) {
                throw new XMLSignatureException(te);
            }
        }
        try {
            if (data != null) {
                XMLSignatureInput xi;
                boolean c14n11 = useC14N11;
                String c14nalg = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
                if (context instanceof XMLSignContext) {
                    if (!c14n11) {
                        Boolean prop = (Boolean)context.getProperty("com.sun.org.apache.xml.internal.security.useC14N11");
                        boolean bl = c14n11 = prop != null && prop == true;
                        if (c14n11) {
                            c14nalg = "http://www.w3.org/2006/12/xml-c14n11";
                        }
                    } else {
                        c14nalg = "http://www.w3.org/2006/12/xml-c14n11";
                    }
                }
                if (data instanceof ApacheData) {
                    xi = ((ApacheData)data).getXMLSignatureInput();
                } else if (data instanceof OctetStreamData) {
                    xi = new XMLSignatureInput(((OctetStreamData)data).getOctetStream());
                } else if (data instanceof NodeSetData) {
                    TransformService spi = null;
                    try {
                        spi = TransformService.getInstance(c14nalg, "DOM");
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        spi = TransformService.getInstance(c14nalg, "DOM", this.provider);
                    }
                    data = spi.transform(data, context);
                    xi = new XMLSignatureInput(((OctetStreamData)data).getOctetStream());
                } else {
                    throw new XMLSignatureException("unrecognized Data type");
                }
                if (context instanceof XMLSignContext && c14n11 && !xi.isOctetStream() && !xi.isOutputStreamSet()) {
                    DOMTransform t = new DOMTransform(TransformService.getInstance(c14nalg, "DOM"));
                    Element transformsElem = null;
                    String dsPrefix = DOMUtils.getSignaturePrefix(context);
                    if (this.allTransforms.isEmpty()) {
                        transformsElem = DOMUtils.createElement(this.refElem.getOwnerDocument(), "Transforms", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
                        this.refElem.insertBefore(transformsElem, DOMUtils.getFirstChildElement(this.refElem));
                    } else {
                        transformsElem = DOMUtils.getFirstChildElement(this.refElem);
                    }
                    t.marshal(transformsElem, dsPrefix, (DOMCryptoContext)context);
                    this.allTransforms.add(t);
                    xi.updateOutputStream(os, true);
                } else {
                    xi.updateOutputStream(os);
                }
            }
            ((OutputStream)os).flush();
            if (cache != null && cache.booleanValue()) {
                this.dis = dos.getInputStream();
            }
            return dos.getDigestValue();
        }
        catch (Exception e) {
            throw new XMLSignatureException(e);
        }
    }

    @Override
    public Node getHere() {
        return this.here;
    }

    public boolean equals(Object o) {
        boolean urisEqual;
        boolean idsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference oref = (Reference)o;
        boolean bl = this.id == null ? oref.getId() == null : (idsEqual = this.id.equals(oref.getId()));
        boolean bl2 = this.uri == null ? oref.getURI() == null : (urisEqual = this.uri.equals(oref.getURI()));
        boolean typesEqual = this.type == null ? oref.getType() == null : this.type.equals(oref.getType());
        boolean digestValuesEqual = Arrays.equals(this.digestValue, oref.getDigestValue());
        return this.digestMethod.equals(oref.getDigestMethod()) && idsEqual && urisEqual && typesEqual && this.allTransforms.equals(oref.getTransforms());
    }

    boolean isDigested() {
        return this.digested;
    }

    private static Data copyDerefData(Data dereferencedData) {
        if (dereferencedData instanceof ApacheData) {
            ApacheData ad = (ApacheData)dereferencedData;
            XMLSignatureInput xsi = ad.getXMLSignatureInput();
            if (xsi.isNodeSet()) {
                try {
                    final Set s = xsi.getNodeSet();
                    return new NodeSetData(){

                        @Override
                        public Iterator iterator() {
                            return s.iterator();
                        }
                    };
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "cannot cache dereferenced data: " + e);
                    return null;
                }
            }
            if (xsi.isElement()) {
                return new DOMSubTreeData(xsi.getSubNode(), xsi.isExcludeComments());
            }
            if (xsi.isOctetStream() || xsi.isByteArray()) {
                try {
                    return new OctetStreamData(xsi.getOctetStream(), xsi.getSourceURI(), xsi.getMIMEType());
                }
                catch (IOException ioe) {
                    log.log(Level.WARNING, "cannot cache dereferenced data: " + ioe);
                    return null;
                }
            }
        }
        return dereferencedData;
    }
}

