/*======================================================================
 FILE: icalparam.h
 CREATOR: eric 20 March 1999

 (C) COPYRIGHT 2000, Eric Busboom, http://www.softwarestudio.org

 This program is free software; you can redistribute it and/or modify
 it under the terms of either:

    The LGPL as published by the Free Software Foundation, version
    2.1, available at: http://www.fsf.org/copyleft/lesser.html

 Or:

    The Mozilla Public License Version 1.0. You may obtain a copy of
    the License at http://www.mozilla.org/MPL/

  The original code is icalparam.h
======================================================================*/
#ifndef ICALDERIVEDPARAMETER_H
#define ICALDERIVEDPARAMETER_H

#include "libical_ical_export.h"

typedef struct icalparameter_impl icalparameter;

LIBICAL_ICAL_EXPORT const char* icalparameter_enum_to_string(int e);
LIBICAL_ICAL_EXPORT int icalparameter_string_to_enum(const char* str);

/* START of section of machine generated code (mkderivedparameters.pl). Do not edit. */

typedef enum icalparameter_kind {
    ICAL_ANY_PARAMETER = 0,
    ICAL_ACTIONPARAM_PARAMETER = 1, 
    ICAL_ALTREP_PARAMETER = 2, 
    ICAL_CHARSET_PARAMETER = 3, 
    ICAL_CN_PARAMETER = 4, 
    ICAL_CUTYPE_PARAMETER = 5, 
    ICAL_DELEGATEDFROM_PARAMETER = 6, 
    ICAL_DELEGATEDTO_PARAMETER = 7, 
    ICAL_DIR_PARAMETER = 8, 
    ICAL_ENABLE_PARAMETER = 9, 
    ICAL_ENCODING_PARAMETER = 10, 
    ICAL_FBTYPE_PARAMETER = 11, 
    ICAL_FILENAME_PARAMETER = 42, 
    ICAL_FMTTYPE_PARAMETER = 12, 
    ICAL_IANA_PARAMETER = 33, 
    ICAL_ID_PARAMETER = 13, 
    ICAL_LANGUAGE_PARAMETER = 14, 
    ICAL_LATENCY_PARAMETER = 15, 
    ICAL_LOCAL_PARAMETER = 16, 
    ICAL_LOCALIZE_PARAMETER = 17, 
    ICAL_MANAGEDID_PARAMETER = 40, 
    ICAL_MEMBER_PARAMETER = 18, 
    ICAL_MODIFIED_PARAMETER = 44, 
    ICAL_OPTIONS_PARAMETER = 19, 
    ICAL_PARTSTAT_PARAMETER = 20, 
    ICAL_PUBLICCOMMENT_PARAMETER = 37, 
    ICAL_RANGE_PARAMETER = 21, 
    ICAL_REASON_PARAMETER = 43, 
    ICAL_RELATED_PARAMETER = 22, 
    ICAL_RELTYPE_PARAMETER = 23, 
    ICAL_REQUIRED_PARAMETER = 43, 
    ICAL_RESPONSE_PARAMETER = 38, 
    ICAL_ROLE_PARAMETER = 24, 
    ICAL_RSVP_PARAMETER = 25, 
    ICAL_SCHEDULEAGENT_PARAMETER = 34, 
    ICAL_SCHEDULEFORCESEND_PARAMETER = 35, 
    ICAL_SCHEDULESTATUS_PARAMETER = 36, 
    ICAL_SENTBY_PARAMETER = 26, 
    ICAL_SIZE_PARAMETER = 41, 
    ICAL_STAYINFORMED_PARAMETER = 39, 
    ICAL_SUBSTATE_PARAMETER = 45, 
    ICAL_TZID_PARAMETER = 27, 
    ICAL_VALUE_PARAMETER = 28, 
    ICAL_X_PARAMETER = 29, 
    ICAL_XLICCOMPARETYPE_PARAMETER = 30, 
    ICAL_XLICERRORTYPE_PARAMETER = 31, 
    ICAL_NO_PARAMETER = 32
} icalparameter_kind;

#define ICALPARAMETER_FIRST_ENUM 20000

typedef enum icalparameter_action {
    ICAL_ACTIONPARAM_X = 20000,
    ICAL_ACTIONPARAM_ASK = 20001,
    ICAL_ACTIONPARAM_ABORT = 20002,
    ICAL_ACTIONPARAM_NONE = 20099
} icalparameter_action;

typedef enum icalparameter_cutype {
    ICAL_CUTYPE_X = 20100,
    ICAL_CUTYPE_INDIVIDUAL = 20101,
    ICAL_CUTYPE_GROUP = 20102,
    ICAL_CUTYPE_RESOURCE = 20103,
    ICAL_CUTYPE_ROOM = 20104,
    ICAL_CUTYPE_UNKNOWN = 20105,
    ICAL_CUTYPE_NONE = 20199
} icalparameter_cutype;

typedef enum icalparameter_enable {
    ICAL_ENABLE_X = 20200,
    ICAL_ENABLE_TRUE = 20201,
    ICAL_ENABLE_FALSE = 20202,
    ICAL_ENABLE_NONE = 20299
} icalparameter_enable;

typedef enum icalparameter_encoding {
    ICAL_ENCODING_X = 20300,
    ICAL_ENCODING_8BIT = 20301,
    ICAL_ENCODING_BASE64 = 20302,
    ICAL_ENCODING_NONE = 20399
} icalparameter_encoding;

typedef enum icalparameter_fbtype {
    ICAL_FBTYPE_X = 20400,
    ICAL_FBTYPE_FREE = 20401,
    ICAL_FBTYPE_BUSY = 20402,
    ICAL_FBTYPE_BUSYUNAVAILABLE = 20403,
    ICAL_FBTYPE_BUSYTENTATIVE = 20404,
    ICAL_FBTYPE_NONE = 20499
} icalparameter_fbtype;

typedef enum icalparameter_local {
    ICAL_LOCAL_X = 20500,
    ICAL_LOCAL_TRUE = 20501,
    ICAL_LOCAL_FALSE = 20502,
    ICAL_LOCAL_NONE = 20599
} icalparameter_local;

typedef enum icalparameter_partstat {
    ICAL_PARTSTAT_X = 20600,
    ICAL_PARTSTAT_NEEDSACTION = 20601,
    ICAL_PARTSTAT_ACCEPTED = 20602,
    ICAL_PARTSTAT_DECLINED = 20603,
    ICAL_PARTSTAT_TENTATIVE = 20604,
    ICAL_PARTSTAT_DELEGATED = 20605,
    ICAL_PARTSTAT_COMPLETED = 20606,
    ICAL_PARTSTAT_INPROCESS = 20607,
    ICAL_PARTSTAT_FAILED = 20608,
    ICAL_PARTSTAT_NONE = 20699
} icalparameter_partstat;

typedef enum icalparameter_range {
    ICAL_RANGE_X = 20700,
    ICAL_RANGE_THISANDPRIOR = 20701,
    ICAL_RANGE_THISANDFUTURE = 20702,
    ICAL_RANGE_NONE = 20799
} icalparameter_range;

typedef enum icalparameter_related {
    ICAL_RELATED_X = 20800,
    ICAL_RELATED_START = 20801,
    ICAL_RELATED_END = 20802,
    ICAL_RELATED_NONE = 20899
} icalparameter_related;

typedef enum icalparameter_reltype {
    ICAL_RELTYPE_X = 20900,
    ICAL_RELTYPE_PARENT = 20901,
    ICAL_RELTYPE_CHILD = 20902,
    ICAL_RELTYPE_SIBLING = 20903,
    ICAL_RELTYPE_POLL = 20904,
    ICAL_RELTYPE_NONE = 20999
} icalparameter_reltype;

typedef enum icalparameter_required {
    ICAL_REQUIRED_X = 21000,
    ICAL_REQUIRED_TRUE = 21001,
    ICAL_REQUIRED_FALSE = 21002,
    ICAL_REQUIRED_NONE = 21099
} icalparameter_required;

typedef enum icalparameter_role {
    ICAL_ROLE_X = 21100,
    ICAL_ROLE_CHAIR = 21101,
    ICAL_ROLE_REQPARTICIPANT = 21102,
    ICAL_ROLE_OPTPARTICIPANT = 21103,
    ICAL_ROLE_NONPARTICIPANT = 21104,
    ICAL_ROLE_NONE = 21199
} icalparameter_role;

typedef enum icalparameter_rsvp {
    ICAL_RSVP_X = 21200,
    ICAL_RSVP_TRUE = 21201,
    ICAL_RSVP_FALSE = 21202,
    ICAL_RSVP_NONE = 21299
} icalparameter_rsvp;

typedef enum icalparameter_scheduleagent {
    ICAL_SCHEDULEAGENT_X = 21300,
    ICAL_SCHEDULEAGENT_SERVER = 21301,
    ICAL_SCHEDULEAGENT_CLIENT = 21302,
    ICAL_SCHEDULEAGENT_NONE = 21399
} icalparameter_scheduleagent;

typedef enum icalparameter_scheduleforcesend {
    ICAL_SCHEDULEFORCESEND_X = 21400,
    ICAL_SCHEDULEFORCESEND_REQUEST = 21401,
    ICAL_SCHEDULEFORCESEND_REPLY = 21402,
    ICAL_SCHEDULEFORCESEND_NONE = 21499
} icalparameter_scheduleforcesend;

typedef enum icalparameter_stayinformed {
    ICAL_STAYINFORMED_X = 21500,
    ICAL_STAYINFORMED_TRUE = 21501,
    ICAL_STAYINFORMED_FALSE = 21502,
    ICAL_STAYINFORMED_NONE = 21599
} icalparameter_stayinformed;

typedef enum icalparameter_substate {
    ICAL_SUBSTATE_X = 21900,
    ICAL_SUBSTATE_OK = 21901,
    ICAL_SUBSTATE_ERROR = 21902,
    ICAL_SUBSTATE_SUSPENDED = 21903,
    ICAL_SUBSTATE_NONE = 21999
} icalparameter_substate;

typedef enum icalparameter_value {
    ICAL_VALUE_X = 21600,
    ICAL_VALUE_BINARY = 21601,
    ICAL_VALUE_BOOLEAN = 21602,
    ICAL_VALUE_DATE = 21603,
    ICAL_VALUE_DURATION = 21604,
    ICAL_VALUE_FLOAT = 21605,
    ICAL_VALUE_INTEGER = 21606,
    ICAL_VALUE_PERIOD = 21607,
    ICAL_VALUE_RECUR = 21608,
    ICAL_VALUE_TEXT = 21609,
    ICAL_VALUE_URI = 21610,
    ICAL_VALUE_ERROR = 21611,
    ICAL_VALUE_DATETIME = 21612,
    ICAL_VALUE_UTCOFFSET = 21613,
    ICAL_VALUE_CALADDRESS = 21614,
    ICAL_VALUE_NONE = 21699
} icalparameter_value;

typedef enum icalparameter_xliccomparetype {
    ICAL_XLICCOMPARETYPE_X = 21700,
    ICAL_XLICCOMPARETYPE_EQUAL = 21701,
    ICAL_XLICCOMPARETYPE_NOTEQUAL = 21702,
    ICAL_XLICCOMPARETYPE_LESS = 21703,
    ICAL_XLICCOMPARETYPE_GREATER = 21704,
    ICAL_XLICCOMPARETYPE_LESSEQUAL = 21705,
    ICAL_XLICCOMPARETYPE_GREATEREQUAL = 21706,
    ICAL_XLICCOMPARETYPE_REGEX = 21707,
    ICAL_XLICCOMPARETYPE_ISNULL = 21708,
    ICAL_XLICCOMPARETYPE_ISNOTNULL = 21709,
    ICAL_XLICCOMPARETYPE_NONE = 21799
} icalparameter_xliccomparetype;

typedef enum icalparameter_xlicerrortype {
    ICAL_XLICERRORTYPE_X = 21800,
    ICAL_XLICERRORTYPE_COMPONENTPARSEERROR = 21801,
    ICAL_XLICERRORTYPE_PROPERTYPARSEERROR = 21802,
    ICAL_XLICERRORTYPE_PARAMETERNAMEPARSEERROR = 21803,
    ICAL_XLICERRORTYPE_PARAMETERVALUEPARSEERROR = 21804,
    ICAL_XLICERRORTYPE_VALUEPARSEERROR = 21805,
    ICAL_XLICERRORTYPE_INVALIDITIP = 21806,
    ICAL_XLICERRORTYPE_UNKNOWNVCALPROPERROR = 21807,
    ICAL_XLICERRORTYPE_MIMEPARSEERROR = 21808,
    ICAL_XLICERRORTYPE_VCALPROPPARSEERROR = 21809,
    ICAL_XLICERRORTYPE_NONE = 21899
} icalparameter_xlicerrortype;

#define ICALPARAMETER_LAST_ENUM 22000

/* ACTIONPARAM */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_actionparam(icalparameter_action v);
LIBICAL_ICAL_EXPORT icalparameter_action icalparameter_get_actionparam(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_actionparam(icalparameter* value, icalparameter_action v);

/* ALTREP */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_altrep(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_altrep(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_altrep(icalparameter* value, const char* v);

/* CHARSET */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_charset(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_charset(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_charset(icalparameter* value, const char* v);

/* CN */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_cn(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_cn(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_cn(icalparameter* value, const char* v);

/* CUTYPE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_cutype(icalparameter_cutype v);
LIBICAL_ICAL_EXPORT icalparameter_cutype icalparameter_get_cutype(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_cutype(icalparameter* value, icalparameter_cutype v);

/* DELEGATED-FROM */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_delegatedfrom(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_delegatedfrom(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_delegatedfrom(icalparameter* value, const char* v);

/* DELEGATED-TO */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_delegatedto(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_delegatedto(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_delegatedto(icalparameter* value, const char* v);

/* DIR */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_dir(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_dir(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_dir(icalparameter* value, const char* v);

/* ENABLE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_enable(icalparameter_enable v);
LIBICAL_ICAL_EXPORT icalparameter_enable icalparameter_get_enable(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_enable(icalparameter* value, icalparameter_enable v);

/* ENCODING */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_encoding(icalparameter_encoding v);
LIBICAL_ICAL_EXPORT icalparameter_encoding icalparameter_get_encoding(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_encoding(icalparameter* value, icalparameter_encoding v);

/* FBTYPE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_fbtype(icalparameter_fbtype v);
LIBICAL_ICAL_EXPORT icalparameter_fbtype icalparameter_get_fbtype(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_fbtype(icalparameter* value, icalparameter_fbtype v);

/* FILENAME */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_filename(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_filename(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_filename(icalparameter* value, const char* v);

/* FMTTYPE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_fmttype(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_fmttype(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_fmttype(icalparameter* value, const char* v);

/* IANA */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_iana(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_iana(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_iana(icalparameter* value, const char* v);

/* ID */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_id(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_id(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_id(icalparameter* value, const char* v);

/* LANGUAGE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_language(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_language(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_language(icalparameter* value, const char* v);

/* LATENCY */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_latency(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_latency(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_latency(icalparameter* value, const char* v);

/* LOCAL */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_local(icalparameter_local v);
LIBICAL_ICAL_EXPORT icalparameter_local icalparameter_get_local(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_local(icalparameter* value, icalparameter_local v);

/* LOCALIZE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_localize(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_localize(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_localize(icalparameter* value, const char* v);

/* MANAGED-ID */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_managedid(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_managedid(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_managedid(icalparameter* value, const char* v);

/* MEMBER */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_member(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_member(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_member(icalparameter* value, const char* v);

/* MODIFIED */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_modified(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_modified(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_modified(icalparameter* value, const char* v);

/* OPTIONS */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_options(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_options(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_options(icalparameter* value, const char* v);

/* PARTSTAT */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_partstat(icalparameter_partstat v);
LIBICAL_ICAL_EXPORT icalparameter_partstat icalparameter_get_partstat(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_partstat(icalparameter* value, icalparameter_partstat v);

/* PUBLIC-COMMENT */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_publiccomment(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_publiccomment(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_publiccomment(icalparameter* value, const char* v);

/* RANGE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_range(icalparameter_range v);
LIBICAL_ICAL_EXPORT icalparameter_range icalparameter_get_range(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_range(icalparameter* value, icalparameter_range v);

/* REASON */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_reason(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_reason(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_reason(icalparameter* value, const char* v);

/* RELATED */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_related(icalparameter_related v);
LIBICAL_ICAL_EXPORT icalparameter_related icalparameter_get_related(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_related(icalparameter* value, icalparameter_related v);

/* RELTYPE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_reltype(icalparameter_reltype v);
LIBICAL_ICAL_EXPORT icalparameter_reltype icalparameter_get_reltype(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_reltype(icalparameter* value, icalparameter_reltype v);

/* REQUIRED */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_required(icalparameter_required v);
LIBICAL_ICAL_EXPORT icalparameter_required icalparameter_get_required(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_required(icalparameter* value, icalparameter_required v);

/* RESPONSE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_response(int v);
LIBICAL_ICAL_EXPORT int icalparameter_get_response(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_response(icalparameter* value, int v);

/* ROLE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_role(icalparameter_role v);
LIBICAL_ICAL_EXPORT icalparameter_role icalparameter_get_role(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_role(icalparameter* value, icalparameter_role v);

/* RSVP */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_rsvp(icalparameter_rsvp v);
LIBICAL_ICAL_EXPORT icalparameter_rsvp icalparameter_get_rsvp(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_rsvp(icalparameter* value, icalparameter_rsvp v);

/* SCHEDULE-AGENT */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_scheduleagent(icalparameter_scheduleagent v);
LIBICAL_ICAL_EXPORT icalparameter_scheduleagent icalparameter_get_scheduleagent(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_scheduleagent(icalparameter* value, icalparameter_scheduleagent v);

/* SCHEDULE-FORCE-SEND */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_scheduleforcesend(icalparameter_scheduleforcesend v);
LIBICAL_ICAL_EXPORT icalparameter_scheduleforcesend icalparameter_get_scheduleforcesend(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_scheduleforcesend(icalparameter* value, icalparameter_scheduleforcesend v);

/* SCHEDULE-STATUS */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_schedulestatus(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_schedulestatus(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_schedulestatus(icalparameter* value, const char* v);

/* SENT-BY */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_sentby(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_sentby(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_sentby(icalparameter* value, const char* v);

/* SIZE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_size(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_size(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_size(icalparameter* value, const char* v);

/* STAY-INFORMED */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_stayinformed(icalparameter_stayinformed v);
LIBICAL_ICAL_EXPORT icalparameter_stayinformed icalparameter_get_stayinformed(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_stayinformed(icalparameter* value, icalparameter_stayinformed v);

/* SUBSTATE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_substate(icalparameter_substate v);
LIBICAL_ICAL_EXPORT icalparameter_substate icalparameter_get_substate(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_substate(icalparameter* value, icalparameter_substate v);

/* TZID */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_tzid(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_tzid(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_tzid(icalparameter* value, const char* v);

/* VALUE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_value(icalparameter_value v);
LIBICAL_ICAL_EXPORT icalparameter_value icalparameter_get_value(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_value(icalparameter* value, icalparameter_value v);

/* X */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_x(const char* v);
LIBICAL_ICAL_EXPORT const char* icalparameter_get_x(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_x(icalparameter* value, const char* v);

/* X-LIC-COMPARETYPE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_xliccomparetype(icalparameter_xliccomparetype v);
LIBICAL_ICAL_EXPORT icalparameter_xliccomparetype icalparameter_get_xliccomparetype(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_xliccomparetype(icalparameter* value, icalparameter_xliccomparetype v);

/* X-LIC-ERRORTYPE */
LIBICAL_ICAL_EXPORT icalparameter* icalparameter_new_xlicerrortype(icalparameter_xlicerrortype v);
LIBICAL_ICAL_EXPORT icalparameter_xlicerrortype icalparameter_get_xlicerrortype(const icalparameter* value);
LIBICAL_ICAL_EXPORT void icalparameter_set_xlicerrortype(icalparameter* value, icalparameter_xlicerrortype v);

#endif /*ICALPARAMETER_H*/

/* END   of section of machine generated code (mkderivedparameters.pl). Do not edit. */

