/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.tomcat.util.http.fileupload.DeferredFileOutputStream;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileUploadException;

public class DefaultFileItem
implements FileItem {
    private static int counter = 0;
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private int sizeThreshold;
    private File repository;
    private byte[] cachedContent;
    private DeferredFileOutputStream dfos;

    DefaultFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.dfos.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        return this.dfos.isInMemory();
    }

    public long getSize() {
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] get() {
        if (this.dfos.isInMemory()) {
            if (this.cachedContent != null) return this.cachedContent;
            this.cachedContent = this.dfos.getData();
            return this.cachedContent;
        }
        byte[] fileData = new byte[(int)this.getSize()];
        FileInputStream fis = null;
        fis = new FileInputStream(this.dfos.getFile());
        fis.read(fileData);
        Object var5_3 = null;
        if (fis == null) return fileData;
        try {
            fis.close();
            return fileData;
        }
        catch (IOException e2) {}
        return fileData;
        {
            catch (IOException e) {
                fileData = null;
                Object var5_4 = null;
                if (fis == null) return fileData;
                try {
                    fis.close();
                    return fileData;
                }
                catch (IOException e2) {}
                return fileData;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public String getString() {
        return new String(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file) throws Exception {
        if (this.isInMemory()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                fout.write(this.get());
                Object var4_4 = null;
                if (fout == null) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            fout.close();
            return;
        }
        File outputFile = this.getStoreLocation();
        if (outputFile == null) throw new FileUploadException("Cannot write uploaded file to disk!");
        if (outputFile.renameTo(file)) return;
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(outputFile));
            out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] bytes = new byte[2048];
            int s = 0;
            while ((s = in.read(bytes)) != -1) {
                ((BufferedOutputStream)out).write(bytes, 0, s);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            out.close();
            return;
        }
        catch (IOException e) {}
    }

    public void delete() {
        this.cachedContent = null;
        File outputFile = this.getStoreLocation();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            File outputFile = this.getTempFile();
            this.dfos = new DeferredFileOutputStream(this.sizeThreshold, outputFile);
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos.getFile();
    }

    protected void finalize() {
        File outputFile = this.dfos.getFile();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    protected File getTempFile() {
        File tempDir = this.repository;
        if (tempDir == null) {
            tempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        String fileName = "upload_" + DefaultFileItem.getUniqueId() + ".tmp";
        File f = new File(tempDir, fileName);
        f.deleteOnExit();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId() {
        Class<DefaultFileItem> clazz = DefaultFileItem.class;
        synchronized (DefaultFileItem.class) {
            int current = counter++;
            // ** MonitorExit[var1] (shouldn't be in output)
            String id = Integer.toString(current);
            if (current < 100000000) {
                id = ("00000000" + id).substring(id.length());
            }
            return id;
        }
    }
}

