/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.media.nativewindow.DefaultGraphicsDevice;
import javax.media.nativewindow.NativeWindowFactory;

public class AWTGraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    private GraphicsDevice device;

    public AWTGraphicsDevice(GraphicsDevice graphicsDevice, int n) {
        super(NativeWindowFactory.TYPE_AWT, graphicsDevice.getIDstring(), n);
        this.device = graphicsDevice;
    }

    public static AWTGraphicsDevice createDefault() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return new AWTGraphicsDevice(graphicsDevice, 0);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public GraphicsDevice getGraphicsDevice() {
        return this.device;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[type " + this.getType() + ", connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", awtDevice " + this.device + ", handle 0x" + Long.toHexString(this.getHandle()) + "]";
    }
}

