/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder.impl;

import org.grails.encoder.AbstractCharReplacementEncoder;
import org.grails.encoder.CodecIdentifier;
import org.grails.encoder.DefaultCodecIdentifier;
import org.grails.encoder.impl.BasicJSONEncoder;

public class JavaScriptEncoder
extends AbstractCharReplacementEncoder {
    public static final CodecIdentifier JAVASCRIPT_CODEC_IDENTIFIER = new DefaultCodecIdentifier("JavaScript", new String[]{"Js"}){

        @Override
        public boolean isEquivalent(CodecIdentifier other) {
            return super.isEquivalent(other) || BasicJSONEncoder.JSON_CODEC_IDENTIFIER.getCodecName().equals(other.getCodecName());
        }
    };

    public JavaScriptEncoder() {
        super(JAVASCRIPT_CODEC_IDENTIFIER);
    }

    @Override
    protected String escapeCharacter(char ch, char previousChar) {
        switch (ch) {
            case '\"': {
                return "\\u0022";
            }
            case '\'': {
                return "\\u0027";
            }
            case '`': {
                return "\\u0060";
            }
            case '\\': {
                return "\\u005c";
            }
            case '/': {
                return "\\u002f";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                if (previousChar != '\r') {
                    return "\\n";
                }
            }
            case '\r': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\b': {
                return "\\b";
            }
            case '\u000b': {
                return "\\v";
            }
            case '&': {
                return "\\u0026";
            }
            case '<': {
                return "\\u003c";
            }
            case '>': {
                return "\\u003e";
            }
            case '(': {
                return "\\u0028";
            }
            case ')': {
                return "\\u0029";
            }
            case '[': {
                return "\\u005b";
            }
            case ']': {
                return "\\u005d";
            }
            case '{': {
                return "\\u007b";
            }
            case '}': {
                return "\\u007d";
            }
            case ',': {
                return "\\u002c";
            }
            case ';': {
                return "\\u003b";
            }
            case '@': {
                return "\\u0040";
            }
            case '\u2028': {
                return "\\u2028";
            }
            case '\u2029': {
                return "\\u2029";
            }
        }
        if (ch < ' ') {
            return "";
        }
        return null;
    }

    @Override
    public boolean isApplyToSafelyEncoded() {
        return true;
    }
}

