/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.sunos;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    EPERM(1),
    ENOENT(2),
    ESRCH(3),
    EINTR(4),
    EIO(5),
    ENXIO(6),
    E2BIG(7),
    ENOEXEC(8),
    EBADF(9),
    ECHILD(10),
    EDEADLK(45),
    ENOMEM(12),
    EACCES(13),
    EFAULT(14),
    ENOTBLK(15),
    EBUSY(16),
    EEXIST(17),
    EXDEV(18),
    ENODEV(19),
    ENOTDIR(20),
    EISDIR(21),
    EINVAL(22),
    ENFILE(23),
    EMFILE(24),
    ENOTTY(25),
    ETXTBSY(26),
    EFBIG(27),
    ENOSPC(28),
    ESPIPE(29),
    EROFS(30),
    EMLINK(31),
    EPIPE(32),
    EDOM(33),
    ERANGE(34),
    EWOULDBLOCK(11),
    EAGAIN(11),
    EINPROGRESS(150),
    EALREADY(149),
    ENOTSOCK(95),
    EDESTADDRREQ(96),
    EMSGSIZE(97),
    EPROTOTYPE(98),
    ENOPROTOOPT(99),
    EPROTONOSUPPORT(120),
    ESOCKTNOSUPPORT(121),
    EOPNOTSUPP(122),
    EPFNOSUPPORT(123),
    EAFNOSUPPORT(124),
    EADDRINUSE(125),
    EADDRNOTAVAIL(126),
    ENETDOWN(127),
    ENETUNREACH(128),
    ENETRESET(129),
    ECONNABORTED(130),
    ECONNRESET(131),
    ENOBUFS(132),
    EISCONN(133),
    ENOTCONN(134),
    ESHUTDOWN(143),
    ETOOMANYREFS(144),
    ETIMEDOUT(145),
    ECONNREFUSED(146),
    ELOOP(90),
    ENAMETOOLONG(78),
    EHOSTDOWN(147),
    EHOSTUNREACH(148),
    ENOTEMPTY(93),
    EUSERS(94),
    EDQUOT(49),
    ESTALE(151),
    EREMOTE(66),
    ENOLCK(46),
    ENOSYS(89),
    EOVERFLOW(79),
    EIDRM(36),
    ENOMSG(35),
    EILSEQ(88),
    EBADMSG(77),
    EMULTIHOP(74),
    ENODATA(61),
    ENOLINK(67),
    ENOSR(63),
    ENOSTR(60),
    EPROTO(71),
    ETIME(62);

    private final int value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 151L;

    private Errno(int value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(EPERM, "Not owner");
            map2.put(ENOENT, "No such file or directory");
            map2.put(ESRCH, "No such process");
            map2.put(EINTR, "Interrupted system call");
            map2.put(EIO, "I/O error");
            map2.put(ENXIO, "No such device or address");
            map2.put(E2BIG, "Arg list too long");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(EBADF, "Bad file number");
            map2.put(ECHILD, "No child processes");
            map2.put(EDEADLK, "Deadlock situation detected/avoided");
            map2.put(ENOMEM, "Not enough space");
            map2.put(EACCES, "Permission denied");
            map2.put(EFAULT, "Bad address");
            map2.put(ENOTBLK, "Block device required");
            map2.put(EBUSY, "Device busy");
            map2.put(EEXIST, "File exists");
            map2.put(EXDEV, "Cross-device link");
            map2.put(ENODEV, "No such device");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EISDIR, "Is a directory");
            map2.put(EINVAL, "Invalid argument");
            map2.put(ENFILE, "File table overflow");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENOTTY, "Inappropriate ioctl for device");
            map2.put(ETXTBSY, "Text file busy");
            map2.put(EFBIG, "File too large");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ESPIPE, "Illegal seek");
            map2.put(EROFS, "Read-only file system");
            map2.put(EMLINK, "Too many links");
            map2.put(EPIPE, "Broken pipe");
            map2.put(EDOM, "Argument out of domain");
            map2.put(ERANGE, "Result too large");
            map2.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(EINPROGRESS, "Operation now in progress");
            map2.put(EALREADY, "Operation already in progress");
            map2.put(ENOTSOCK, "Socket operation on non-socket");
            map2.put(EDESTADDRREQ, "Destination address required");
            map2.put(EMSGSIZE, "Message too long");
            map2.put(EPROTOTYPE, "Protocol wrong type for socket");
            map2.put(ENOPROTOOPT, "Option not supported by protocol");
            map2.put(EPROTONOSUPPORT, "Protocol not supported");
            map2.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map2.put(EOPNOTSUPP, "Operation not supported on transport endpoint");
            map2.put(EPFNOSUPPORT, "Protocol family not supported");
            map2.put(EAFNOSUPPORT, "Address family not supported by protocol family");
            map2.put(EADDRINUSE, "Address already in use");
            map2.put(EADDRNOTAVAIL, "Cannot assign requested address");
            map2.put(ENETDOWN, "Network is down");
            map2.put(ENETUNREACH, "Network is unreachable");
            map2.put(ENETRESET, "Network dropped connection because of reset");
            map2.put(ECONNABORTED, "Software caused connection abort");
            map2.put(ECONNRESET, "Connection reset by peer");
            map2.put(ENOBUFS, "No buffer space available");
            map2.put(EISCONN, "Transport endpoint is already connected");
            map2.put(ENOTCONN, "Transport endpoint is not connected");
            map2.put(ESHUTDOWN, "Cannot send after socket shutdown");
            map2.put(ETOOMANYREFS, "Too many references: cannot splice");
            map2.put(ETIMEDOUT, "Connection timed out");
            map2.put(ECONNREFUSED, "Connection refused");
            map2.put(ELOOP, "Number of symbolic links encountered during path name traversal exceeds MAXSYMLINKS");
            map2.put(ENAMETOOLONG, "File name too long");
            map2.put(EHOSTDOWN, "Host is down");
            map2.put(EHOSTUNREACH, "No route to host");
            map2.put(ENOTEMPTY, "Directory not empty");
            map2.put(EUSERS, "Too many users");
            map2.put(EDQUOT, "Disc quota exceeded");
            map2.put(ESTALE, "Stale NFS file handle");
            map2.put(EREMOTE, "Object is remote");
            map2.put(ENOLCK, "No record locks available");
            map2.put(ENOSYS, "Operation not applicable");
            map2.put(EOVERFLOW, "Value too large for defined data type");
            map2.put(EIDRM, "Identifier removed");
            map2.put(ENOMSG, "No message of desired type");
            map2.put(EILSEQ, "Illegal byte sequence");
            map2.put(EBADMSG, "Not a data message");
            map2.put(EMULTIHOP, "Multihop attempted");
            map2.put(ENODATA, "No data available");
            map2.put(ENOLINK, "Link has been severed");
            map2.put(ENOSR, "Out of stream resources");
            map2.put(ENOSTR, "Not a stream device");
            map2.put(EPROTO, "Protocol error");
            map2.put(ETIME, "Timer expired");
            return map2;
        }
    }
}

