/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.Future;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;

public final class ThreadedActionListener<Response>
implements ActionListener<Response> {
    private final ESLogger logger;
    private final ThreadPool threadPool;
    private final String executor;
    private final ActionListener<Response> listener;

    public ThreadedActionListener(ESLogger logger, ThreadPool threadPool, String executor, ActionListener<Response> listener) {
        this.logger = logger;
        this.threadPool = threadPool;
        this.executor = executor;
        this.listener = listener;
    }

    @Override
    public void onResponse(final Response response) {
        this.threadPool.executor(this.executor).execute(new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                ThreadedActionListener.this.listener.onResponse(response);
            }

            @Override
            public void onFailure(Throwable t) {
                ThreadedActionListener.this.listener.onFailure(t);
            }
        });
    }

    @Override
    public void onFailure(final Throwable e) {
        this.threadPool.executor(this.executor).execute(new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                ThreadedActionListener.this.listener.onFailure(e);
            }

            @Override
            public void onFailure(Throwable t) {
                ThreadedActionListener.this.logger.warn("failed to execute failure callback on [{}], failure [{}]", t, ThreadedActionListener.this.listener, e);
            }
        });
    }

    public static class Wrapper {
        private final ESLogger logger;
        private final ThreadPool threadPool;
        private final boolean threadedListener;

        public Wrapper(ESLogger logger, Settings settings, ThreadPool threadPool) {
            this.logger = logger;
            this.threadPool = threadPool;
            this.threadedListener = DiscoveryNode.clientNode(settings) || "transport".equals(settings.get("client.type"));
        }

        public <Response> ActionListener<Response> wrap(ActionListener<Response> listener) {
            if (!this.threadedListener) {
                return listener;
            }
            if (listener instanceof Future) {
                return listener;
            }
            if (listener instanceof ThreadedActionListener) {
                return listener;
            }
            return new ThreadedActionListener<Response>(this.logger, this.threadPool, "listener", listener);
        }
    }
}

