/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.breaker;

import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.ByteSizeValue;

public class MemoryCircuitBreaker
implements CircuitBreaker {
    private final long memoryBytesLimit;
    private final double overheadConstant;
    private final AtomicLong used;
    private final AtomicLong trippedCount;
    private final ESLogger logger;

    public MemoryCircuitBreaker(ByteSizeValue limit, double overheadConstant, ESLogger logger) {
        this(limit, overheadConstant, null, logger);
    }

    public MemoryCircuitBreaker(ByteSizeValue limit, double overheadConstant, MemoryCircuitBreaker oldBreaker, ESLogger logger) {
        this.memoryBytesLimit = limit.bytes();
        this.overheadConstant = overheadConstant;
        if (oldBreaker == null) {
            this.used = new AtomicLong(0L);
            this.trippedCount = new AtomicLong(0L);
        } else {
            this.used = oldBreaker.used;
            this.trippedCount = oldBreaker.trippedCount;
        }
        this.logger = logger;
        if (logger.isTraceEnabled()) {
            logger.trace("Creating MemoryCircuitBreaker with a limit of {} bytes ({}) and a overhead constant of {}", this.memoryBytesLimit, limit, this.overheadConstant);
        }
    }

    @Override
    public void circuitBreak(String fieldName, long bytesNeeded) throws CircuitBreakingException {
        this.trippedCount.incrementAndGet();
        String message = "Data too large, data for field [" + fieldName + "] would be larger than limit of [" + this.memoryBytesLimit + "/" + new ByteSizeValue(this.memoryBytesLimit) + "]";
        this.logger.debug("{}", message);
        throw new CircuitBreakingException(message, bytesNeeded, this.memoryBytesLimit);
    }

    @Override
    public double addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
        long newUsed;
        long currentUsed;
        if (this.memoryBytesLimit == 0L) {
            this.circuitBreak(label, bytes);
        }
        if (this.memoryBytesLimit == -1L) {
            long newUsed2 = this.used.addAndGet(bytes);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adding [{}][{}] to used bytes [new used: [{}], limit: [-1b]]", new ByteSizeValue(bytes), label, new ByteSizeValue(newUsed2));
            }
            return newUsed2;
        }
        do {
            currentUsed = this.used.get();
            newUsed = currentUsed + bytes;
            long newUsedWithOverhead = (long)((double)newUsed * this.overheadConstant);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adding [{}][{}] to used bytes [new used: [{}], limit: {} [{}], estimate: {} [{}]]", new ByteSizeValue(bytes), label, new ByteSizeValue(newUsed), this.memoryBytesLimit, new ByteSizeValue(this.memoryBytesLimit), newUsedWithOverhead, new ByteSizeValue(newUsedWithOverhead));
            }
            if (this.memoryBytesLimit <= 0L || newUsedWithOverhead <= this.memoryBytesLimit) continue;
            this.logger.warn("New used memory {} [{}] from field [{}] would be larger than configured breaker: {} [{}], breaking", newUsedWithOverhead, new ByteSizeValue(newUsedWithOverhead), label, this.memoryBytesLimit, new ByteSizeValue(this.memoryBytesLimit));
            this.circuitBreak(label, newUsedWithOverhead);
        } while (!this.used.compareAndSet(currentUsed, newUsed));
        return newUsed;
    }

    @Override
    public long addWithoutBreaking(long bytes) {
        long u = this.used.addAndGet(bytes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Adjusted breaker by [{}] bytes, now [{}]", bytes, u);
        }
        assert (u >= 0L) : "Used bytes: [" + u + "] must be >= 0";
        return u;
    }

    @Override
    public long getUsed() {
        return this.used.get();
    }

    @Override
    public long getLimit() {
        return this.memoryBytesLimit;
    }

    @Override
    public double getOverhead() {
        return this.overheadConstant;
    }

    @Override
    public long getTrippedCount() {
        return this.trippedCount.get();
    }

    @Override
    public String getName() {
        return "fielddata";
    }
}

