/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.Lucene43NGramTokenFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class NGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int minGram;
    private final int maxGram;

    @Inject
    public NGramTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.minGram = settings.getAsInt("min_gram", (Integer)1);
        this.maxGram = settings.getAsInt("max_gram", (Integer)2);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        Version version;
        Version version2 = version = this.version == Version.LUCENE_4_3 ? Version.LUCENE_4_4 : this.version;
        if (version.onOrAfter(Version.LUCENE_4_3)) {
            return new NGramTokenFilter(tokenStream, this.minGram, this.maxGram);
        }
        return new Lucene43NGramTokenFilter(tokenStream, this.minGram, this.maxGram);
    }
}

