/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;

public class StringFieldMapper
extends FieldMapper
implements AllFieldMapper.IncludeInAll {
    public static final String CONTENT_TYPE = "string";
    private static final int POSITION_INCREMENT_GAP_USE_ANALYZER = -1;
    private Boolean includeInAll;
    private int positionIncrementGap;
    private int ignoreAbove;

    protected StringFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, int positionIncrementGap, int ignoreAbove, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        if (fieldType.tokenized() && fieldType.indexOptions() != IndexOptions.NONE && this.fieldType().hasDocValues()) {
            throw new MapperParsingException("Field [" + fieldType.names().fullName() + "] cannot be analyzed and have doc values");
        }
        this.positionIncrementGap = positionIncrementGap;
        this.ignoreAbove = ignoreAbove;
    }

    @Override
    protected StringFieldMapper clone() {
        return (StringFieldMapper)super.clone();
    }

    @Override
    public StringFieldMapper includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            StringFieldMapper clone = this.clone();
            clone.includeInAll = includeInAll;
            return clone;
        }
        return this;
    }

    @Override
    public StringFieldMapper includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            StringFieldMapper clone = this.clone();
            clone.includeInAll = includeInAll;
            return clone;
        }
        return this;
    }

    @Override
    public StringFieldMapper unsetIncludeInAll() {
        if (this.includeInAll != null) {
            StringFieldMapper clone = this.clone();
            clone.includeInAll = null;
            return clone;
        }
        return this;
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    public int getPositionIncrementGap() {
        return this.positionIncrementGap;
    }

    public int getIgnoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        ValueAndBoost valueAndBoost = StringFieldMapper.parseCreateFieldForString(context, this.fieldType().nullValueAsString(), this.fieldType().boost());
        if (valueAndBoost.value() == null) {
            return;
        }
        if (this.ignoreAbove > 0 && valueAndBoost.value().length() > this.ignoreAbove) {
            return;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().names().fullName(), valueAndBoost.value(), valueAndBoost.boost());
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            Field field = new Field(this.fieldType().names().indexName(), valueAndBoost.value(), (FieldType)this.fieldType());
            field.setBoost(valueAndBoost.boost());
            fields.add(field);
        }
        if (this.fieldType().hasDocValues()) {
            fields.add((Field)new SortedSetDocValuesField(this.fieldType().names().indexName(), new BytesRef((CharSequence)valueAndBoost.value())));
        }
    }

    public static ValueAndBoost parseCreateFieldForString(ParseContext context, String nullValue, float defaultBoost) throws IOException {
        if (context.externalValueSet()) {
            return new ValueAndBoost(context.externalValue().toString(), defaultBoost);
        }
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return new ValueAndBoost(nullValue, defaultBoost);
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            XContentParser.Token token;
            String currentFieldName = null;
            String value = nullValue;
            float boost = defaultBoost;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                    value = parser.textOrNull();
                    continue;
                }
                if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
            }
            return new ValueAndBoost(value, boost);
        }
        return new ValueAndBoost(parser.textOrNull(), defaultBoost);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        this.includeInAll = ((StringFieldMapper)mergeWith).includeInAll;
        this.ignoreAbove = ((StringFieldMapper)mergeWith).ignoreAbove;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        this.doXContentAnalyzers(builder, includeDefaults);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
        if (includeDefaults || this.positionIncrementGap != -1) {
            builder.field("position_increment_gap", this.positionIncrementGap);
        }
        if (includeDefaults || this.ignoreAbove != -1) {
            builder.field("ignore_above", this.ignoreAbove);
        }
    }

    public static class ValueAndBoost {
        private final String value;
        private final float boost;

        public ValueAndBoost(String value, float boost) {
            this.value = value;
            this.boost = boost;
        }

        public String value() {
            return this.value;
        }

        public float boost() {
            return this.boost;
        }
    }

    public static final class StringFieldType
    extends MappedFieldType
    implements org.elasticsearch.index.mapper.StringFieldType {
        public StringFieldType() {
        }

        protected StringFieldType(StringFieldType ref) {
            super(ref);
        }

        @Override
        public StringFieldType clone() {
            return new StringFieldType(this);
        }

        @Override
        public String typeName() {
            return StringFieldMapper.CONTENT_TYPE;
        }

        @Override
        public String value(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        @Override
        public Query nullValueQuery() {
            if (this.nullValue() == null) {
                return null;
            }
            return this.termQuery(this.nullValue(), null);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.stringField(name);
            TypeParsers.parseTextField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("search_quote_analyzer")) {
                    NamedAnalyzer analyzer = parserContext.analysisService().analyzer(propNode.toString());
                    if (analyzer == null) {
                        throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                    }
                    builder.searchQuotedAnalyzer(analyzer);
                    iterator.remove();
                    continue;
                }
                if (propName.equals("position_increment_gap") || parserContext.indexVersionCreated().before(Version.V_2_0_0) && propName.equals("position_offset_gap")) {
                    int newPositionIncrementGap = XContentMapValues.nodeIntegerValue(propNode, -1);
                    if (newPositionIncrementGap < 0) {
                        throw new MapperParsingException("positions_increment_gap less than 0 aren't allowed.");
                    }
                    builder.positionIncrementGap(newPositionIncrementGap);
                    if (builder.fieldType().indexAnalyzer() == null) {
                        builder.fieldType().setIndexAnalyzer(parserContext.analysisService().defaultIndexAnalyzer());
                    }
                    if (builder.fieldType().searchAnalyzer() == null) {
                        builder.fieldType().setSearchAnalyzer(parserContext.analysisService().defaultSearchAnalyzer());
                    }
                    if (builder.fieldType().searchQuoteAnalyzer() == null) {
                        builder.fieldType().setSearchQuoteAnalyzer(parserContext.analysisService().defaultSearchQuoteAnalyzer());
                    }
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_above")) {
                    builder.ignoreAbove(XContentMapValues.nodeIntegerValue(propNode, -1));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, StringFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        protected int positionIncrementGap = -1;
        protected int ignoreAbove = -1;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            super.searchAnalyzer(searchAnalyzer);
            return this;
        }

        public Builder positionIncrementGap(int positionIncrementGap) {
            this.positionIncrementGap = positionIncrementGap;
            return this;
        }

        public Builder searchQuotedAnalyzer(NamedAnalyzer analyzer) {
            this.fieldType.setSearchQuoteAnalyzer(analyzer);
            return (Builder)this.builder;
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        @Override
        public StringFieldMapper build(Mapper.BuilderContext context) {
            if (this.fieldType.indexOptions() != IndexOptions.NONE && !this.fieldType.tokenized()) {
                this.defaultFieldType.setOmitNorms(true);
                this.defaultFieldType.setIndexOptions(IndexOptions.DOCS);
                if (!this.omitNormsSet && this.fieldType.boost() == 1.0f) {
                    this.fieldType.setOmitNorms(true);
                }
                if (!this.indexOptionsSet) {
                    this.fieldType.setIndexOptions(IndexOptions.DOCS);
                }
            }
            if (this.positionIncrementGap != -1) {
                if (this.fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
                }
                this.fieldType.setIndexAnalyzer(new NamedAnalyzer(this.fieldType.indexAnalyzer(), this.positionIncrementGap));
                this.fieldType.setSearchAnalyzer(new NamedAnalyzer(this.fieldType.searchAnalyzer(), this.positionIncrementGap));
                this.fieldType.setSearchQuoteAnalyzer(new NamedAnalyzer(this.fieldType.searchQuoteAnalyzer(), this.positionIncrementGap));
            }
            this.setupFieldType(context);
            StringFieldMapper fieldMapper = new StringFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.positionIncrementGap, this.ignoreAbove, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            return fieldMapper.includeInAll(this.includeInAll);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new StringFieldType();
        public static final String NULL_VALUE;
        public static final int POSITION_INCREMENT_GAP = 100;
        public static final int POSITION_INCREMENT_GAP_PRE_2_0 = 0;
        public static final int IGNORE_ABOVE = -1;

        public static int positionIncrementGap(Version version) {
            if (version.before(Version.V_2_0_0_beta1)) {
                return 0;
            }
            return 100;
        }

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

