/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class BoolQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<BoolQueryBuilder> {
    private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();
    private float boost = -1.0f;
    private Boolean disableCoord;
    private String minimumShouldMatch;
    private Boolean adjustPureNegative;
    private String queryName;

    public BoolQueryBuilder must(QueryBuilder queryBuilder) {
        this.mustClauses.add(queryBuilder);
        return this;
    }

    public BoolQueryBuilder filter(QueryBuilder queryBuilder) {
        this.filterClauses.add(queryBuilder);
        return this;
    }

    public BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
        this.mustNotClauses.add(queryBuilder);
        return this;
    }

    public BoolQueryBuilder should(QueryBuilder queryBuilder) {
        this.shouldClauses.add(queryBuilder);
        return this;
    }

    @Override
    public BoolQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public BoolQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    public BoolQueryBuilder minimumNumberShouldMatch(int minimumNumberShouldMatch) {
        this.minimumShouldMatch = Integer.toString(minimumNumberShouldMatch);
        return this;
    }

    public BoolQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public boolean hasClauses() {
        return !this.mustClauses.isEmpty() || !this.shouldClauses.isEmpty() || !this.mustNotClauses.isEmpty() || !this.filterClauses.isEmpty();
    }

    public BoolQueryBuilder adjustPureNegative(boolean adjustPureNegative) {
        this.adjustPureNegative = adjustPureNegative;
        return this;
    }

    public BoolQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("bool");
        this.doXArrayContent("must", this.mustClauses, builder, params);
        this.doXArrayContent("filter", this.filterClauses, builder, params);
        this.doXArrayContent("must_not", this.mustNotClauses, builder, params);
        this.doXArrayContent("should", this.shouldClauses, builder, params);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.disableCoord != null) {
            builder.field("disable_coord", (Object)this.disableCoord);
        }
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.adjustPureNegative != null) {
            builder.field("adjust_pure_negative", (Object)this.adjustPureNegative);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }

    private void doXArrayContent(String field, List<QueryBuilder> clauses, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (clauses.isEmpty()) {
            return;
        }
        if (clauses.size() == 1) {
            builder.field(field);
            clauses.get(0).toXContent(builder, params);
        } else {
            builder.startArray(field);
            for (QueryBuilder clause : clauses) {
                clause.toXContent(builder, params);
            }
            builder.endArray();
        }
    }
}

