/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class HistogramAggregator
extends BucketsAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final ValueFormatter formatter;
    private final Rounding rounding;
    private final InternalOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final ExtendedBounds extendedBounds;
    private final InternalHistogram.Factory histogramFactory;
    private final LongHash bucketOrds;

    public HistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, InternalOrder order, boolean keyed, long minDocCount, @Nullable ExtendedBounds extendedBounds, @Nullable ValuesSource.Numeric valuesSource, ValueFormatter formatter, InternalHistogram.Factory<?> histogramFactory, AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.rounding = rounding;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        this.histogramFactory = histogramFactory;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                values.setDocument(doc);
                int valuesCount = values.count();
                long previousKey = Long.MIN_VALUE;
                for (int i = 0; i < valuesCount; ++i) {
                    long value = values.valueAt(i);
                    long key = HistogramAggregator.this.rounding.roundKey(value);
                    assert (key >= previousKey);
                    if (key == previousKey) continue;
                    long bucketOrd = HistogramAggregator.this.bucketOrds.add(key);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        HistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                    } else {
                        HistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                    }
                    previousKey = key;
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        ArrayList buckets = new ArrayList((int)this.bucketOrds.size());
        for (long i = 0L; i < this.bucketOrds.size(); ++i) {
            buckets.add(this.histogramFactory.createBucket(this.rounding.valueForKey(this.bucketOrds.get(i)), this.bucketDocCount(i), this.bucketAggregations(i), this.keyed, this.formatter));
        }
        CollectionUtil.introSort(buckets, InternalOrder.KEY_ASC.comparator());
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return this.histogramFactory.create(this.name, buckets, this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return this.histogramFactory.create(this.name, Collections.emptyList(), this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory<ValuesSource.Numeric> {
        private final Rounding rounding;
        private final InternalOrder order;
        private final boolean keyed;
        private final long minDocCount;
        private final ExtendedBounds extendedBounds;
        private final InternalHistogram.Factory<?> histogramFactory;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> config, Rounding rounding, InternalOrder order, boolean keyed, long minDocCount, ExtendedBounds extendedBounds, InternalHistogram.Factory<?> histogramFactory) {
            super(name, histogramFactory.type(), config);
            this.rounding = rounding;
            this.order = order;
            this.keyed = keyed;
            this.minDocCount = minDocCount;
            this.extendedBounds = extendedBounds;
            this.histogramFactory = histogramFactory;
        }

        public long minDocCount() {
            return this.minDocCount;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            ExtendedBounds roundedBounds = null;
            if (this.extendedBounds != null) {
                this.extendedBounds.processAndValidate(this.name, aggregationContext.searchContext(), this.config.parser());
                roundedBounds = this.extendedBounds.round(this.rounding);
            }
            return new HistogramAggregator(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, roundedBounds, null, this.config.formatter(), this.histogramFactory, aggregationContext, parent, pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            if (!collectsFromSingleBucket) {
                return Factory.asMultiBucketAggregator(this, aggregationContext, parent);
            }
            ExtendedBounds roundedBounds = null;
            if (this.extendedBounds != null) {
                this.extendedBounds.processAndValidate(this.name, aggregationContext.searchContext(), this.config.parser());
                roundedBounds = this.extendedBounds.round(this.rounding);
            }
            return new HistogramAggregator(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, roundedBounds, valuesSource, this.config.formatter(), this.histogramFactory, aggregationContext, parent, pipelineAggregators, metaData);
        }
    }
}

