/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.scan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.MinDocQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.search.internal.SearchContext;

public class ScanContext {
    private volatile int docUpTo;

    public ScanCollector collector(SearchContext context) {
        return this.collector(context.size(), context.trackScores());
    }

    ScanCollector collector(int size, boolean trackScores) {
        return new ScanCollector(size, trackScores);
    }

    public Query wrapQuery(Query query) {
        return Queries.filtered(query, new MinDocQuery(this.docUpTo));
    }

    public class ScanCollector
    extends SimpleCollector {
        private final List<ScoreDoc> docs;
        private final int size;
        private final boolean trackScores;
        private Scorer scorer;
        private int docBase;

        private ScanCollector(int size, boolean trackScores) {
            this.trackScores = trackScores;
            this.docs = new ArrayList<ScoreDoc>(size);
            this.size = size;
        }

        public TopDocs topDocs() {
            return new TopDocs(this.docs.size(), this.docs.toArray(new ScoreDoc[this.docs.size()]), 0.0f);
        }

        public boolean needsScores() {
            return this.trackScores;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            int topLevelDoc = this.docBase + doc;
            this.docs.add(new ScoreDoc(topLevelDoc, this.trackScores ? this.scorer.score() : 0.0f));
            assert (topLevelDoc >= ScanContext.this.docUpTo);
            ScanContext.this.docUpTo = topLevelDoc + 1;
            if (this.docs.size() >= this.size) {
                throw new CollectionTerminatedException();
            }
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            if (this.docs.size() >= this.size || context.docBase + context.reader().maxDoc() <= ScanContext.this.docUpTo) {
                throw new CollectionTerminatedException();
            }
            this.docBase = context.docBase;
        }
    }
}

