/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractAsyncBulkIndexByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.ReindexResponse;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportReindexAction
extends HandledTransportAction<ReindexRequest, ReindexResponse> {
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final AutoCreateIndex autoCreateIndex;
    private final Client client;

    @Inject
    public TransportReindexAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService) {
        super(settings, "indices:data/write/reindex", threadPool, transportService, actionFilters, indexNameExpressionResolver, ReindexRequest.class);
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.autoCreateIndex = autoCreateIndex;
        this.client = client;
    }

    protected void doExecute(Task task, ReindexRequest request, ActionListener<ReindexResponse> listener) {
        TransportReindexAction.validateAgainstAliases(request.getSearchRequest(), request.getDestination(), this.indexNameExpressionResolver, this.autoCreateIndex, this.clusterService.state());
        new AsyncIndexBySearchAction((BulkByScrollTask)task, this.logger, this.scriptService, this.client, this.threadPool, this.clusterService.state().nodes().smallestNonClientNodeVersion(), request, listener).start();
    }

    protected void doExecute(ReindexRequest request, ActionListener<ReindexResponse> listener) {
        throw new UnsupportedOperationException("task required");
    }

    static String validateAgainstAliases(SearchRequest source, IndexRequest destination, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, ClusterState clusterState) {
        String target = destination.index();
        if (!autoCreateIndex.shouldAutoCreate(target, clusterState)) {
            target = indexNameExpressionResolver.concreteIndices(clusterState, (IndicesRequest)destination)[0];
        }
        for (String sourceIndex : indexNameExpressionResolver.concreteIndices(clusterState, (IndicesRequest)source)) {
            if (!sourceIndex.equals(target)) continue;
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError("reindex cannot write into an index its reading from [" + target + ']');
            throw e;
        }
        return target;
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkIndexByScrollAction<ReindexRequest, ReindexResponse> {
        public AsyncIndexBySearchAction(BulkByScrollTask task, ESLogger logger, ScriptService scriptService, Client client, ThreadPool threadPool, Version smallestNonClientVersion, ReindexRequest request, ActionListener<ReindexResponse> listener) {
            super(task, logger, scriptService, client, threadPool, smallestNonClientVersion, request, request.getSearchRequest(), listener);
        }

        @Override
        protected IndexRequest buildIndexRequest(SearchHit doc) {
            IndexRequest index = new IndexRequest((ActionRequest)this.mainRequest);
            index.index(((ReindexRequest)this.mainRequest).getDestination().index());
            if (((ReindexRequest)this.mainRequest).getDestination().type() == null) {
                index.type(doc.type());
            } else {
                index.type(((ReindexRequest)this.mainRequest).getDestination().type());
            }
            index.versionType(((ReindexRequest)this.mainRequest).getDestination().versionType());
            if (index.versionType() == VersionType.INTERNAL) {
                index.version(((ReindexRequest)this.mainRequest).getDestination().version());
            } else {
                index.version(doc.version());
            }
            index.id(doc.id());
            index.source(doc.sourceRef());
            index.routing(((ReindexRequest)this.mainRequest).getDestination().routing());
            index.parent(((ReindexRequest)this.mainRequest).getDestination().parent());
            index.timestamp(((ReindexRequest)this.mainRequest).getDestination().timestamp());
            index.ttl(((ReindexRequest)this.mainRequest).getDestination().ttl());
            index.contentType(((ReindexRequest)this.mainRequest).getDestination().getContentType());
            index.opType(((ReindexRequest)this.mainRequest).getDestination().opType());
            return index;
        }

        @Override
        protected void copyRouting(IndexRequest index, SearchHit doc) {
            String routingSpec = ((ReindexRequest)this.mainRequest).getDestination().routing();
            if (routingSpec == null) {
                super.copyRouting(index, doc);
                return;
            }
            if (routingSpec.startsWith("=")) {
                index.routing(((ReindexRequest)this.mainRequest).getDestination().routing().substring(1));
                return;
            }
            switch (routingSpec) {
                case "keep": {
                    super.copyRouting(index, doc);
                    break;
                }
                case "discard": {
                    index.routing(null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported routing command");
                }
            }
        }

        @Override
        protected ReindexResponse buildResponse(TimeValue took, List<BulkItemResponse.Failure> indexingFailures, List<ShardSearchFailure> searchFailures, boolean timedOut) {
            return new ReindexResponse(took, this.task.getStatus(), indexingFailures, searchFailures, timedOut);
        }

        @Override
        protected void scriptChangedIndex(IndexRequest index, Object to) {
            Objects.requireNonNull(to, "Can't reindex without a destination index!");
            index.index(to.toString());
        }

        @Override
        protected void scriptChangedType(IndexRequest index, Object to) {
            Objects.requireNonNull(to, "Can't reindex without a destination type!");
            index.type(to.toString());
        }

        @Override
        protected void scriptChangedId(IndexRequest index, Object to) {
            index.id(Objects.toString(to, null));
        }

        @Override
        protected void scriptChangedVersion(IndexRequest index, Object to) {
            if (to == null) {
                index.version(-3L).versionType(VersionType.INTERNAL);
                return;
            }
            index.version(this.asLong(to, "_version"));
        }

        @Override
        protected void scriptChangedParent(IndexRequest index, Object to) {
            String routing = Objects.toString(to, null);
            index.parent(routing).routing(routing);
        }

        @Override
        protected void scriptChangedRouting(IndexRequest index, Object to) {
            index.routing(Objects.toString(to, null));
        }

        @Override
        protected void scriptChangedTimestamp(IndexRequest index, Object to) {
            index.timestamp(Objects.toString(to, null));
        }

        @Override
        protected void scriptChangedTTL(IndexRequest index, Object to) {
            if (to == null) {
                index.ttl((TimeValue)null);
                return;
            }
            index.ttl(this.asLong(to, "_ttl"));
        }

        private long asLong(Object from, String name) {
            Number fromNumber;
            try {
                fromNumber = (Number)from;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + from + "]", e);
            }
            long l = fromNumber.longValue();
            if (fromNumber.doubleValue() != (double)l) {
                throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + from + "]");
            }
            return l;
        }
    }
}

