/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;

public abstract class ValueSourceScorer
extends Scorer {
    protected final FunctionValues values;
    private final TwoPhaseIterator twoPhaseIterator;
    private final DocIdSetIterator disi;

    protected ValueSourceScorer(IndexReader reader, FunctionValues values) {
        super(null);
        this.values = values;
        DocIdSetIterator approximation = DocIdSetIterator.all((int)reader.maxDoc());
        this.twoPhaseIterator = new TwoPhaseIterator(approximation){

            public boolean matches() throws IOException {
                return ValueSourceScorer.this.matches(this.approximation.docID());
            }

            public float matchCost() {
                return 100.0f;
            }
        };
        this.disi = TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseIterator);
    }

    public abstract boolean matches(int var1);

    public DocIdSetIterator iterator() {
        return this.disi;
    }

    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhaseIterator;
    }

    public int docID() {
        return this.disi.docID();
    }

    public float score() throws IOException {
        float score = this.values.floatVal(this.disi.docID());
        return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
    }

    public int freq() throws IOException {
        return 1;
    }
}

