/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryGridUnit
extends GridUnit {
    private TableCellLayoutManager cellLM;
    private List elements;
    private int rowIndex;
    private int colIndex;
    private List<GridUnit[]> rows;
    private int contentLength = -1;
    private boolean isSeparateBorderModel;
    private int halfBorderSeparationBPD;
    private Keep keepWithPrevious = Keep.KEEP_AUTO;
    private Keep keepWithNext = Keep.KEEP_AUTO;
    private int breakBefore = 9;
    private int breakAfter = 9;

    PrimaryGridUnit(TableCell cell, int colIndex) {
        super(cell, 0, 0);
        this.colIndex = colIndex;
        this.isSeparateBorderModel = cell.getTable().isSeparateBorderModel();
        this.halfBorderSeparationBPD = cell.getTable().getBorderSeparation().getBPD().getLength().getValue() / 2;
    }

    public TablePart getTablePart() {
        FONode node = this.cell.getParent();
        if (node instanceof TableRow) {
            node = node.getParent();
        }
        return (TablePart)node;
    }

    public TableCellLayoutManager getCellLM() {
        assert (this.cellLM != null);
        return this.cellLM;
    }

    @Override
    public PrimaryGridUnit getPrimary() {
        return this;
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public List getElements() {
        return this.elements;
    }

    public int getBeforeAfterBorderWidth() {
        return this.getBeforeBorderWidth(0, 0) + this.getAfterBorderWidth(0);
    }

    public int getBeforeBorderWidth(int rowIndex, int which) {
        if (this.isSeparateBorderModel) {
            if (this.getCell() == null) {
                return 0;
            }
            CommonBorderPaddingBackground cellBorders = this.getCell().getCommonBorderPaddingBackground();
            switch (which) {
                case 0: 
                case 1: {
                    return cellBorders.getBorderBeforeWidth(false) + this.halfBorderSeparationBPD;
                }
                case 2: {
                    if (cellBorders.getBorderInfo(0).getWidth().isDiscard()) {
                        return 0;
                    }
                    return cellBorders.getBorderBeforeWidth(true) + this.halfBorderSeparationBPD;
                }
            }
            assert (false);
            return 0;
        }
        int width = 0;
        for (GridUnit gu : this.rows.get(rowIndex)) {
            width = Math.max(width, gu.getBorderBefore(which).getRetainedWidth());
        }
        return width / 2;
    }

    public int getAfterBorderWidth(int rowIndex, int which) {
        GridUnit[] row;
        if (this.isSeparateBorderModel) {
            if (this.getCell() == null) {
                return 0;
            }
            CommonBorderPaddingBackground cellBorders = this.getCell().getCommonBorderPaddingBackground();
            switch (which) {
                case 0: 
                case 1: {
                    return cellBorders.getBorderAfterWidth(false) + this.halfBorderSeparationBPD;
                }
                case 2: {
                    if (cellBorders.getBorderInfo(1).getWidth().isDiscard()) {
                        return 0;
                    }
                    return cellBorders.getBorderAfterWidth(true) + this.halfBorderSeparationBPD;
                }
            }
            assert (false);
            return 0;
        }
        int width = 0;
        for (GridUnit gu : row = this.rows.get(rowIndex)) {
            width = Math.max(width, gu.getBorderAfter(which).getRetainedWidth());
        }
        return width / 2;
    }

    public int getAfterBorderWidth(int which) {
        return this.getAfterBorderWidth(this.getCell().getNumberRowsSpanned() - 1, which);
    }

    public int getContentLength() {
        if (this.contentLength < 0) {
            this.contentLength = ElementListUtils.calcContentLength(this.elements);
        }
        return this.contentLength;
    }

    public List<GridUnit[]> getRows() {
        return this.rows;
    }

    public void addRow(GridUnit[] row) {
        if (this.rows == null) {
            this.rows = new ArrayList<GridUnit[]>();
        }
        this.rows.add(row);
    }

    void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public int[] getStartEndBorderWidths() {
        int[] widths = new int[2];
        if (this.getCell() == null) {
            return widths;
        }
        if (this.getCell().getTable().isSeparateBorderModel()) {
            widths[0] = this.getCell().getCommonBorderPaddingBackground().getBorderStartWidth(false);
            widths[1] = this.getCell().getCommonBorderPaddingBackground().getBorderEndWidth(false);
        } else {
            for (GridUnit[] gridUnits : this.rows) {
                widths[0] = Math.max(widths[0], gridUnits[0].borderStart.getBorderInfo().getRetainedWidth());
                widths[1] = Math.max(widths[1], gridUnits[gridUnits.length - 1].borderEnd.getBorderInfo().getRetainedWidth());
            }
        }
        return widths;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" rowIndex=").append(this.rowIndex);
        sb.append(" colIndex=").append(this.colIndex);
        return sb.toString();
    }

    public boolean hasSpanning() {
        return this.getCell().getNumberColumnsSpanned() > 1 || this.getCell().getNumberRowsSpanned() > 1;
    }

    public void createCellLM() {
        this.cellLM = new TableCellLayoutManager(this.cell, this);
    }

    public Keep getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public void setKeepWithPrevious(Keep keep) {
        this.keepWithPrevious = keep;
    }

    public Keep getKeepWithNext() {
        return this.keepWithNext;
    }

    public void setKeepWithNext(Keep keep) {
        this.keepWithNext = keep;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public void setBreakBefore(int breakBefore) {
        this.breakBefore = breakBefore;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public void setBreakAfter(int breakAfter) {
        this.breakAfter = breakAfter;
    }
}

