/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeProjectDirectoryMapper;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilder;
import org.gradle.plugins.ide.internal.tooling.TasksFactory;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseBuildCommand;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseExternalDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseJavaSourceSettings;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseLinkedResource;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProject;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectNature;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseSourceDirectory;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseTask;
import org.gradle.plugins.ide.internal.tooling.eclipse.EclipseWtpSupport;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.tooling.internal.gradle.DefaultGradleProject;
import org.gradle.tooling.provider.model.internal.ProjectToolingModelBuilder;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseModelBuilder
implements ProjectToolingModelBuilder {
    private final GradleProjectBuilder gradleProjectBuilder;
    private final Transformer<File, String> compositeProjectMapper;
    private boolean projectDependenciesOnly;
    private DefaultEclipseProject result;
    private final Map<String, DefaultEclipseProject> projectMapping = new HashMap<String, DefaultEclipseProject>();
    private TasksFactory tasksFactory;
    private DefaultGradleProject<?> rootGradleProject;
    private Project currentProject;

    public EclipseModelBuilder(GradleProjectBuilder gradleProjectBuilder, ServiceRegistry services) {
        this.gradleProjectBuilder = gradleProjectBuilder;
        this.compositeProjectMapper = new CompositeProjectDirectoryMapper(services);
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.eclipse.EclipseProject") || modelName.equals("org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
    }

    public void addModels(String modelName, Project project, Map<String, Object> models) {
        DefaultEclipseProject eclipseProject = this.buildAll(modelName, project);
        this.addModels(eclipseProject, models);
    }

    private void addModels(DefaultEclipseProject eclipseProject, Map<String, Object> models) {
        models.put(eclipseProject.getPath(), eclipseProject);
        for (DefaultEclipseProject childProject : eclipseProject.getChildren()) {
            this.addModels(childProject, models);
        }
    }

    public DefaultEclipseProject buildAll(String modelName, Project project) {
        boolean includeTasks = modelName.equals("org.gradle.tooling.model.eclipse.EclipseProject");
        this.tasksFactory = new TasksFactory(includeTasks);
        this.projectDependenciesOnly = modelName.equals("org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
        this.currentProject = project;
        Project root = project.getRootProject();
        this.rootGradleProject = this.gradleProjectBuilder.buildAll(project);
        this.tasksFactory.collectTasks(root);
        this.applyEclipsePlugin(root);
        EclipseWtpSupport.applyEclipseWtpPluginOnWebProjects(root);
        this.buildHierarchy(root);
        this.populate(root);
        return this.result;
    }

    private void applyEclipsePlugin(Project root) {
        Set allProjects = root.getAllprojects();
        for (Project p : allProjects) {
            p.getPluginManager().apply(EclipsePlugin.class);
        }
        ((EclipsePlugin)root.getPlugins().getPlugin(EclipsePlugin.class)).makeSureProjectNamesAreUnique();
    }

    private DefaultEclipseProject buildHierarchy(Project project) {
        ArrayList<DefaultEclipseProject> children = new ArrayList<DefaultEclipseProject>();
        for (Project child : project.getChildProjects().values()) {
            children.add(this.buildHierarchy(child));
        }
        EclipseModel eclipseModel = (EclipseModel)((Object)project.getExtensions().getByType(EclipseModel.class));
        EclipseProject internalProject = eclipseModel.getProject();
        String name = internalProject.getName();
        String description = (String)GUtil.elvis((Object)internalProject.getComment(), null);
        DefaultEclipseProject eclipseProject = new DefaultEclipseProject(name, project.getPath(), description, project.getProjectDir(), children).setGradleProject(this.rootGradleProject.findByPath(project.getPath()));
        for (DefaultEclipseProject child : children) {
            child.setParent(eclipseProject);
        }
        this.addProject(project, eclipseProject);
        return eclipseProject;
    }

    private void addProject(Project project, DefaultEclipseProject eclipseProject) {
        if (project == this.currentProject) {
            this.result = eclipseProject;
        }
        this.projectMapping.put(project.getPath(), eclipseProject);
    }

    private void populate(Project project) {
        EclipseModel eclipseModel = (EclipseModel)((Object)project.getExtensions().getByType(EclipseModel.class));
        EclipseClasspath classpath = eclipseModel.getClasspath();
        classpath.setProjectDependenciesOnly(this.projectDependenciesOnly);
        List<ClasspathEntry> entries = classpath.resolveDependencies();
        LinkedList<DefaultEclipseExternalDependency> externalDependencies = new LinkedList<DefaultEclipseExternalDependency>();
        LinkedList<DefaultEclipseProjectDependency> projectDependencies = new LinkedList<DefaultEclipseProjectDependency>();
        LinkedList<DefaultEclipseSourceDirectory> sourceDirectories = new LinkedList<DefaultEclipseSourceDirectory>();
        for (ClasspathEntry entry : entries) {
            String path;
            if (entry instanceof Library) {
                AbstractLibrary library = (AbstractLibrary)entry;
                File file = library.getLibrary().getFile();
                File source = library.getSourcePath() == null ? null : library.getSourcePath().getFile();
                File javadoc = library.getJavadocPath() == null ? null : library.getJavadocPath().getFile();
                DefaultEclipseExternalDependency dependency = new DefaultEclipseExternalDependency(file, javadoc, source, library.getModuleVersion(), library.isExported());
                externalDependencies.add(dependency);
                continue;
            }
            if (entry instanceof ProjectDependency) {
                DefaultEclipseProjectDependency dependency;
                ProjectDependency projectDependency = (ProjectDependency)entry;
                path = StringUtils.removeStart((String)projectDependency.getPath(), (String)"/");
                DefaultEclipseProject targetProject = this.projectMapping.get(projectDependency.getGradlePath());
                if (targetProject == null) {
                    File projectDirectory = (File)this.compositeProjectMapper.transform((Object)projectDependency.getGradlePath());
                    dependency = new DefaultEclipseProjectDependency(path, projectDirectory, projectDependency.isExported());
                } else {
                    dependency = new DefaultEclipseProjectDependency(path, targetProject, projectDependency.isExported());
                }
                projectDependencies.add(dependency);
                continue;
            }
            if (!(entry instanceof SourceFolder)) continue;
            SourceFolder sourceFolder = (SourceFolder)entry;
            path = sourceFolder.getPath();
            sourceDirectories.add(new DefaultEclipseSourceDirectory(path, sourceFolder.getDir()));
        }
        DefaultEclipseProject eclipseProject = this.projectMapping.get(project.getPath());
        eclipseProject.setClasspath(externalDependencies);
        eclipseProject.setProjectDependencies(projectDependencies);
        eclipseProject.setSourceDirectories(sourceDirectories);
        LinkedList<DefaultEclipseLinkedResource> linkedResources = new LinkedList<DefaultEclipseLinkedResource>();
        for (Link r : eclipseModel.getProject().getLinkedResources()) {
            linkedResources.add(new DefaultEclipseLinkedResource(r.getName(), r.getType(), r.getLocation(), r.getLocationUri()));
        }
        eclipseProject.setLinkedResources(linkedResources);
        ArrayList<DefaultEclipseTask> tasks = new ArrayList<DefaultEclipseTask>();
        for (Task t : this.tasksFactory.getTasks(project)) {
            tasks.add(new DefaultEclipseTask(eclipseProject, t.getPath(), t.getName(), t.getDescription()));
        }
        eclipseProject.setTasks(tasks);
        ArrayList<DefaultEclipseProjectNature> natures = new ArrayList<DefaultEclipseProjectNature>();
        for (String n : eclipseModel.getProject().getNatures()) {
            natures.add(new DefaultEclipseProjectNature(n));
        }
        eclipseProject.setProjectNatures(natures);
        ArrayList<DefaultEclipseBuildCommand> buildCommands = new ArrayList<DefaultEclipseBuildCommand>();
        for (BuildCommand b : eclipseModel.getProject().getBuildCommands()) {
            buildCommands.add(new DefaultEclipseBuildCommand(b.getName(), b.getArguments()));
        }
        eclipseProject.setBuildCommands(buildCommands);
        EclipseJdt jdt = eclipseModel.getJdt();
        if (jdt != null) {
            eclipseProject.setJavaSourceSettings(new DefaultEclipseJavaSourceSettings().setSourceLanguageLevel(jdt.getSourceCompatibility()).setTargetBytecodeVersion(jdt.getTargetCompatibility()).setJdk(DefaultInstalledJdk.current()));
        }
        EclipseWtpSupport.enhanceProject(project, projectDependencies, externalDependencies);
        for (Project childProject : project.getChildProjects().values()) {
            this.populate(childProject);
        }
    }
}

