/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.cache.HeapProportionalCacheSizer;
import org.gradle.api.internal.changedetection.state.DefaultVisitedTree;
import org.gradle.api.internal.changedetection.state.VisitedTree;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTreeVisitor {
    public static final boolean CACHING_TREE_VISITOR_FEATURE_ENABLED = Boolean.valueOf(System.getProperty("org.gradle.tree_visitor_cache.enabled", "false"));
    private static final Logger LOG = Logging.getLogger(CachingTreeVisitor.class);
    public static final int VISITED_TREES_CACHE_MAX_SIZE = 500;
    private final Cache<String, VisitedTreeCacheEntry> cachedTrees;
    private final AtomicLong nextId = new AtomicLong(System.currentTimeMillis());
    private volatile HashSet<String> cacheableFilePaths;

    public CachingTreeVisitor() {
        HeapProportionalCacheSizer cacheSizer = new HeapProportionalCacheSizer();
        this.cachedTrees = CacheBuilder.newBuilder().maximumSize((long)cacheSizer.scaleCacheSize(500, 10)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisitedTree visitTreeForSnapshotting(FileTreeInternal fileTree, boolean allowReuse) {
        String treePath = null;
        PatternSet treePattern = null;
        if (CACHING_TREE_VISITOR_FEATURE_ENABLED && this.isDirectoryFileTree(fileTree)) {
            DirectoryFileTree directoryFileTree = (DirectoryFileTree)DirectoryFileTree.class.cast(((FileTreeAdapter)fileTree).getTree());
            treePath = directoryFileTree.getDir().getAbsolutePath();
            treePattern = directoryFileTree.getPatternSet();
            if (this.isCacheablePath(treePath)) {
                VisitedTreeCacheEntry cacheEntry = this.findOrCreateCacheEntry(treePath);
                cacheEntry.lock();
                try {
                    VisitedTree cachedTree = null;
                    if (cacheEntry != null) {
                        if (allowReuse) {
                            cachedTree = cacheEntry.get(treePattern);
                        } else {
                            cacheEntry.clear();
                        }
                    }
                    if (cachedTree != null) {
                        this.recordCacheHit(directoryFileTree);
                        VisitedTree visitedTree = cachedTree;
                        return visitedTree;
                    }
                    this.recordCacheMiss(directoryFileTree, allowReuse);
                    cachedTree = this.doVisitTree(treePath, treePattern, fileTree, true);
                    cacheEntry.put(treePattern, cachedTree);
                    VisitedTree visitedTree = cachedTree;
                    return visitedTree;
                }
                finally {
                    cacheEntry.unlock();
                }
            }
        }
        return this.doVisitTree(treePath, treePattern, fileTree, false);
    }

    private VisitedTreeCacheEntry findOrCreateCacheEntry(String treePath) {
        VisitedTreeCacheEntry cacheEntry;
        try {
            cacheEntry = (VisitedTreeCacheEntry)this.cachedTrees.get((Object)treePath, (Callable)new Callable<VisitedTreeCacheEntry>(){

                @Override
                public VisitedTreeCacheEntry call() {
                    return new VisitedTreeCacheEntry(CachingTreeVisitor.this.nextId);
                }
            });
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return cacheEntry;
    }

    public VisitedTree createJoinedTree(List<VisitedTree> trees, Collection<File> missingFiles) {
        return CachingTreeVisitor.createJoinedTree(this.nextId.incrementAndGet(), trees, missingFiles);
    }

    public static VisitedTree createJoinedTree(long nextId, List<VisitedTree> trees, Collection<File> missingFiles) {
        if (missingFiles.isEmpty()) {
            if (trees.size() == 0) {
                return null;
            }
            if (trees.size() == 1) {
                return trees.get(0);
            }
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (VisitedTree tree : trees) {
            listBuilder.addAll(tree.getEntries());
        }
        return new DefaultVisitedTree(null, null, (List<FileTreeElement>)listBuilder.build(), false, nextId, missingFiles);
    }

    protected void recordCacheHit(DirectoryFileTree directoryFileTree) {
        LOG.debug("Cache hit {}", (Object)directoryFileTree);
    }

    protected void recordCacheMiss(DirectoryFileTree directoryFileTree, boolean allowReuse) {
        if (allowReuse) {
            LOG.debug("Cache miss {}", (Object)directoryFileTree);
        } else {
            LOG.debug("Visiting {}", (Object)directoryFileTree);
        }
    }

    private boolean isCacheablePath(String absolutePath) {
        return this.cacheableFilePaths != null && this.cacheableFilePaths.contains(absolutePath);
    }

    private boolean isDirectoryFileTree(FileTreeInternal fileTree) {
        return fileTree instanceof FileTreeAdapter && ((FileTreeAdapter)fileTree).getTree() instanceof DirectoryFileTree;
    }

    private VisitedTree doVisitTree(String absolutePath, PatternSet patternSet, FileTreeInternal fileTree, boolean shareable) {
        final ImmutableList.Builder fileTreeElements = ImmutableList.builder();
        fileTree.visitTreeOrBackingFile(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                fileTreeElements.add((Object)dirDetails);
            }

            public void visitFile(FileVisitDetails fileDetails) {
                fileTreeElements.add((Object)fileDetails);
            }
        });
        return new DefaultVisitedTree(absolutePath, patternSet, (List<FileTreeElement>)fileTreeElements.build(), shareable, this.nextId.incrementAndGet(), null);
    }

    public void clearCache() {
        this.cachedTrees.invalidateAll();
    }

    public void updateCacheableFilePaths(Collection<String> cacheableFilePaths) {
        this.cacheableFilePaths = cacheableFilePaths != null ? new HashSet<String>(cacheableFilePaths) : null;
    }

    public void invalidateFilePaths(Iterable<String> filePaths) {
        this.cachedTrees.invalidateAll(filePaths);
    }

    private static class VisitedTreeCacheEntry {
        private final ReentrantLock lock = new ReentrantLock();
        private final AtomicLong nextId;
        Map<PatternSet, VisitedTree> treesPerPattern;
        VisitedTree noPatternTree;

        public VisitedTreeCacheEntry(AtomicLong nextId) {
            this.nextId = nextId;
        }

        public VisitedTree get(PatternSet patternSet) {
            if (patternSet == null || patternSet.isEmpty()) {
                return this.noPatternTree;
            }
            if (this.treesPerPattern != null) {
                VisitedTree cachedTree = this.treesPerPattern.get(patternSet);
                if (cachedTree == null && this.noPatternTree != null) {
                    cachedTree = this.filterTree(this.noPatternTree, patternSet, this.nextId);
                }
                return cachedTree;
            }
            return null;
        }

        private VisitedTree filterTree(VisitedTree noPatternTree, PatternSet patternSet, AtomicLong nextId) {
            List<FileTreeElement> filteredEntries = noPatternTree.filter(patternSet);
            if (filteredEntries.size() != noPatternTree.getEntries().size()) {
                return new DefaultVisitedTree(noPatternTree.getAbsolutePath(), patternSet, filteredEntries, true, nextId.incrementAndGet(), null);
            }
            return noPatternTree;
        }

        public void put(PatternSet patternSet, VisitedTree visitedTree) {
            if (patternSet == null || patternSet.isEmpty()) {
                this.noPatternTree = visitedTree;
            } else {
                if (this.treesPerPattern == null) {
                    this.treesPerPattern = new HashMap<PatternSet, VisitedTree>();
                }
                this.treesPerPattern.put(patternSet, visitedTree);
            }
        }

        public void clear() {
            this.noPatternTree = null;
            this.treesPerPattern = null;
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }
    }
}

