/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.internal.changedetection.state.DefaultVisitedTree;
import org.gradle.api.internal.changedetection.state.VisitedTree;
import org.gradle.api.internal.file.BufferedStreamingHasher;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitedTreesPreCheckHasher {
    int calculatePreCheckHash(Collection<VisitedTree> visitedTrees) {
        BufferedStreamingHasher hasher = new BufferedStreamingHasher();
        Encoder encoder = hasher.getEncoder();
        try {
            ArrayList<VisitedTree> sortedTrees = new ArrayList<VisitedTree>(visitedTrees);
            Collections.sort(sortedTrees, DefaultVisitedTree.VisitedTreeComparator.INSTANCE);
            for (VisitedTree tree : sortedTrees) {
                if (tree.getAbsolutePath() != null) {
                    encoder.writeString((CharSequence)tree.getAbsolutePath());
                }
                if (tree.getPatternSet() != null) {
                    encoder.writeInt(tree.getPatternSet().hashCode());
                }
                encoder.writeInt(tree.getEntries().size());
                encoder.writeInt(tree.calculatePreCheckHash());
            }
            return hasher.checksum();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

