/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class HttpBody {
    private static final Logger log = Logger.getLogger(HttpBody.class);
    public static final String DEFAULT_CHARSET = StandardCharsets.ISO_8859_1.name();
    public static final int LIMIT_INITIAL_CAPACITY = 128000;
    private byte[] body;
    private int pos;
    private String cachedString;
    private Charset charset;

    public HttpBody() {
        this(0);
    }

    public HttpBody(int n) {
        this.body = new byte[Math.max(Math.min(n, 128000), 0)];
    }

    public HttpBody(byte[] byArray) {
        if (byArray != null) {
            this.setBody(byArray);
        } else {
            this.body = new byte[0];
        }
    }

    public HttpBody(String string) {
        if (string != null) {
            this.setBody(string);
        } else {
            this.body = new byte[0];
        }
    }

    public void setBody(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.cachedString = null;
        this.body = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.body, 0, byArray.length);
        this.pos = this.body.length;
    }

    public void setBody(String string) {
        if (string == null) {
            return;
        }
        this.cachedString = null;
        this.body = string.getBytes(this.getCharsetImpl());
        this.pos = this.body.length;
    }

    private Charset getCharsetImpl() {
        if (this.charset != null) {
            return this.charset;
        }
        return StandardCharsets.ISO_8859_1;
    }

    public void append(byte[] byArray, int n) {
        if (byArray == null || n <= 0) {
            return;
        }
        int n2 = Math.min(byArray.length, n);
        if (this.pos + n2 > this.body.length) {
            byte[] byArray2 = new byte[this.pos + n2];
            System.arraycopy(this.body, 0, byArray2, 0, this.pos);
            this.body = byArray2;
        }
        System.arraycopy(byArray, 0, this.body, this.pos, n2);
        this.pos += n2;
        this.cachedString = null;
    }

    public void append(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.append(byArray, byArray.length);
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        this.append(string.getBytes(this.getCharsetImpl()));
    }

    public String toString() {
        if (this.cachedString != null) {
            return this.cachedString;
        }
        this.cachedString = this.createString(this.charset);
        return this.cachedString;
    }

    protected String createString(Charset charset) {
        return new String(this.getBytes(), 0, this.getPos(), charset != null ? charset : this.getCharsetImpl());
    }

    protected final int getPos() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.body;
    }

    public int length() {
        return this.body.length;
    }

    public void setLength(int n) {
        if (n < 0 || this.body.length == n) {
            return;
        }
        int n2 = this.pos;
        this.pos = Math.min(this.pos, n);
        byte[] byArray = new byte[n];
        System.arraycopy(this.body, 0, byArray, 0, this.pos);
        this.body = byArray;
        if (n2 > this.pos) {
            this.cachedString = null;
        }
    }

    public String getCharset() {
        if (this.charset != null) {
            return this.charset.name();
        }
        return DEFAULT_CHARSET;
    }

    public void setCharset(String string) {
        if (StringUtils.isEmpty(string)) {
            this.setCharsetImpl(null);
            return;
        }
        Charset charset = null;
        try {
            charset = Charset.forName(string);
            if (charset != this.charset) {
                this.setCharsetImpl(charset);
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            log.error((Object)("Failed to set charset: " + string), (Throwable)illegalArgumentException);
        }
    }

    private void setCharsetImpl(Charset charset) {
        this.charset = charset;
        this.cachedString = null;
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.body);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpBody httpBody = (HttpBody)object;
        return Arrays.equals(this.body, httpBody.body);
    }
}

