/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.lang.ref.SoftReference;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;

public class AntiCsrfToken
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(AntiCsrfToken.class);
    private HttpMessage msg;
    private SoftReference<HttpMessage> msgReference;
    private int historyReferenceId;
    private String name;
    private String value;
    private String targetURL;
    private int formIndex;
    private static ExtensionAntiCSRF.HistoryReferenceFactory historyReferenceFactory;

    static void setHistoryReferenceFactory(ExtensionAntiCSRF.HistoryReferenceFactory historyReferenceFactory) {
        AntiCsrfToken.historyReferenceFactory = historyReferenceFactory;
    }

    public AntiCsrfToken(HttpMessage httpMessage, String string, String string2, int n) {
        this(httpMessage, null, -1, string, string2, n);
    }

    private AntiCsrfToken(HttpMessage httpMessage, SoftReference<HttpMessage> softReference, int n, String string, String string2, int n2) {
        this.msg = httpMessage;
        this.msgReference = softReference;
        this.historyReferenceId = n;
        this.name = string;
        this.value = string2;
        this.formIndex = n2;
    }

    public HttpMessage getMsg() {
        HttpMessage httpMessage;
        if (this.msg != null) {
            return this.msg;
        }
        if (this.msgReference != null) {
            httpMessage = this.msgReference.get();
            if (httpMessage != null) {
                return httpMessage;
            }
            this.msgReference.clear();
            this.msgReference = null;
        }
        if (this.historyReferenceId == -1) {
            return null;
        }
        try {
            httpMessage = historyReferenceFactory.createHistoryReference(this.historyReferenceId).getHttpMessage();
            this.msgReference = new SoftReference<HttpMessage>(httpMessage);
            return httpMessage;
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            LOGGER.error((Object)"Failed to load the persisted message: ", (Throwable)exception);
            return null;
        }
    }

    public void setMsg(HttpMessage httpMessage) {
        this.msg = httpMessage;
        if (this.msgReference != null) {
            this.msgReference.clear();
            this.msgReference = null;
        }
        this.historyReferenceId = -1;
    }

    void setHistoryReferenceId(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter historyReferenceId must be equal or greater than zero.");
        }
        this.setMsg(null);
        this.historyReferenceId = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setTargetURL(String string) {
        this.targetURL = string;
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public int getFormIndex() {
        return this.formIndex;
    }

    public void setFormIndex(int n) {
        this.formIndex = n;
    }

    public AntiCsrfToken clone() {
        return new AntiCsrfToken(this.msg, this.msgReference, this.historyReferenceId, this.name, this.value, this.formIndex);
    }
}

