/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ScanProgressActionIcon;
import org.zaproxy.zap.extension.ascan.ScanProgressItem;

public class ScanProgressTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.progress.table.name"), Constant.messages.getString("ascan.policy.table.strength"), Constant.messages.getString("ascan.progress.table.progress"), Constant.messages.getString("ascan.progress.table.time"), Constant.messages.getString("ascan.progress.table.reqs"), Constant.messages.getString("ascan.progress.table.status")};
    private List<ScanProgressItem> values;
    private List<ScanProgressActionIcon> actions = new ArrayList<ScanProgressActionIcon>();
    private ScanProgressActionIcon focusedAction = null;
    private String totRequests;
    private String totTime;

    public ScanProgressTableModel() {
        this.values = new ArrayList<ScanProgressItem>();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size() + 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < this.values.size()) {
            ScanProgressItem scanProgressItem = this.values.get(n);
            switch (n2) {
                case 0: {
                    return scanProgressItem.getNameLabel();
                }
                case 1: {
                    return scanProgressItem.getAttackStrenghtLabel();
                }
                case 2: {
                    if (scanProgressItem.isCompleted() || scanProgressItem.isRunning() || scanProgressItem.isSkipped()) {
                        return scanProgressItem;
                    }
                    return null;
                }
                case 3: {
                    return this.getElapsedTimeLabel(scanProgressItem.getElapsedTime());
                }
                case 4: {
                    return scanProgressItem.getReqCount();
                }
                case 5: {
                    ScanProgressActionIcon scanProgressActionIcon = null;
                    if (scanProgressItem.isCompleted() || scanProgressItem.isRunning() || scanProgressItem.isSkipped()) {
                        if (n < this.actions.size()) {
                            scanProgressActionIcon = this.actions.get(n);
                            scanProgressActionIcon.updateStatus(scanProgressItem);
                        } else {
                            scanProgressActionIcon = new ScanProgressActionIcon(scanProgressItem);
                            this.actions.add(scanProgressActionIcon);
                        }
                    }
                    return scanProgressActionIcon;
                }
            }
            return null;
        }
        if (n == this.values.size()) {
            return null;
        }
        if (n == this.values.size() + 1) {
            switch (n2) {
                case 0: {
                    return Constant.messages.getString("ascan.progress.label.totals");
                }
                case 3: {
                    return this.totTime;
                }
                case 4: {
                    return this.totRequests;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return ScanProgressItem.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return ScanProgressActionIcon.class;
            }
        }
        return null;
    }

    public List<ScanProgressItem> getValues() {
        return this.values;
    }

    public void setFocusedAction(ScanProgressActionIcon scanProgressActionIcon) {
        this.focusedAction = scanProgressActionIcon;
    }

    public ScanProgressActionIcon getFocusedAction() {
        return this.focusedAction;
    }

    public void updateValues(ActiveScan activeScan, HostProcess hostProcess) {
        this.values.clear();
        for (Plugin plugin : hostProcess.getCompleted()) {
            this.values.add(new ScanProgressItem(hostProcess, plugin, 3));
        }
        for (Plugin plugin : hostProcess.getRunning()) {
            this.values.add(new ScanProgressItem(hostProcess, plugin, 2));
        }
        for (Plugin plugin : hostProcess.getPending()) {
            this.values.add(new ScanProgressItem(hostProcess, plugin, 1));
        }
        Date date = activeScan.getTimeFinished() == null ? new Date() : activeScan.getTimeFinished();
        long l = date.getTime() - activeScan.getTimeStarted().getTime();
        this.totTime = this.getElapsedTimeLabel(l);
        this.totRequests = Integer.toString(activeScan.getTotalRequests());
        this.fireTableDataChanged();
    }

    private String getElapsedTimeLabel(long l) {
        return l >= 0L ? String.format("%02d:%02d.%03d", l / 60000L, l % 60000L / 1000L, l % 1000L) : null;
    }
}

