/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.hex;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.zaproxy.zap.utils.ByteBuilder;

public class HttpPanelHexModel
extends AbstractTableModel {
    private static final String[] hexSymbols = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static final int BITS_PER_HEX_DIGIT = 4;
    private static final int COLUMN_COUNT = 34;
    private static final long serialVersionUID = 1L;
    private List<String[]> listRow = new ArrayList<String[]>();
    private boolean editable = false;
    private boolean changed = false;

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public int getColumnCount() {
        return 34;
    }

    @Override
    public int getRowCount() {
        return this.listRow.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.listRow.get(n)[n2];
    }

    private boolean isHexColumn(int n) {
        return n > 0 && n <= 16;
    }

    private boolean isCharColumn(int n) {
        return n > 17;
    }

    @Override
    public String getColumnName(int n) {
        if (this.isHexColumn(n)) {
            return Integer.toHexString(n - 1);
        }
        if (this.isCharColumn(n)) {
            return Integer.toHexString(n - 18);
        }
        return "";
    }

    public static String toHexFromByte(byte by) {
        byte by2 = (byte)(by >>> 4 & 0xF);
        byte by3 = (byte)(by & 0xF);
        return hexSymbols[by2] + hexSymbols[by3];
    }

    private String[] newRow() {
        String[] stringArray = new String[34];
        stringArray[0] = String.format("%08x", this.listRow.size() * 16);
        return stringArray;
    }

    private void setHex(String[] stringArray, int n, byte by) {
        stringArray[n] = HttpPanelHexModel.toHexFromByte(by);
        stringArray[n + 17] = String.valueOf((char)by);
    }

    private void setChar(String[] stringArray, int n, char c) {
        stringArray[n - 17] = HttpPanelHexModel.toHexFromByte((byte)c);
        stringArray[n] = String.valueOf(c);
    }

    public synchronized void setData(byte[] byArray) {
        this.listRow.clear();
        if (byArray.length != 0 || this.isEditable()) {
            int n = 0;
            String[] stringArray = this.newRow();
            this.listRow.add(stringArray);
            for (int i = 0; i < byArray.length; ++i) {
                this.setHex(stringArray, n + 1, byArray[i]);
                if (++n < 16) continue;
                stringArray = this.newRow();
                this.listRow.add(stringArray);
                n = 0;
            }
        }
        this.fireTableDataChanged();
        this.changed = false;
    }

    public synchronized byte[] getData() {
        ByteBuilder byteBuilder = new ByteBuilder();
        for (String[] stringArray : this.listRow) {
            for (int i = 1; i < 17 && stringArray[i] != null && stringArray[i].length() != 0; ++i) {
                byteBuilder.append((char)Integer.parseInt(stringArray[i], 16));
            }
        }
        return byteBuilder.toByteArray();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isEditable()) {
            return false;
        }
        if (!this.isHexColumn(n2) && !this.isCharColumn(n2)) {
            return false;
        }
        if (n < this.listRow.size() - 1) {
            return true;
        }
        String[] stringArray = this.listRow.get(n);
        if (!this.isCharColumn(n2)) {
            return stringArray[n2 - 1] != null;
        }
        return stringArray[n2 - 1] != null || n2 == 18;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = (String)object;
        byte by = -1;
        char c = '\u0000';
        if (this.isHexColumn(n2)) {
            if (string.length() > 2) {
                return;
            }
            try {
                by = (byte)Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        } else if (this.isCharColumn(n2)) {
            if (string.length() != 1) {
                return;
            }
            c = string.charAt(0);
        } else {
            return;
        }
        String[] stringArray = this.listRow.get(n);
        if (this.isHexColumn(n2)) {
            this.setHex(stringArray, n2, by);
        } else {
            this.setChar(stringArray, n2, c);
        }
        int n3 = n;
        if (n == this.listRow.size() - 1 && stringArray[16] != null) {
            this.listRow.add(this.newRow());
            ++n3;
        }
        this.fireTableRowsUpdated(n, n3);
        this.changed = true;
    }

    public boolean hasChanged() {
        return this.changed;
    }
}

