/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.skin.ListViewSkin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.util.Callback;

@DefaultProperty(value="items")
public class ListView<T>
extends Control {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_COMMIT");
    private EventHandler<EditEvent<T>> DEFAULT_EDIT_COMMIT_HANDLER = new EventHandler<EditEvent<T>>(){

        @Override
        public void handle(EditEvent<T> editEvent) {
            int n = editEvent.getIndex();
            ObservableList observableList = ListView.this.getItems();
            if (n < 0 || n >= observableList.size()) {
                return;
            }
            observableList.set(n, editEvent.getNewValue());
        }
    };
    private ObjectProperty<ObservableList<T>> items;
    private ObjectProperty<MultipleSelectionModel<T>> selectionModel = new SimpleObjectProperty<MultipleSelectionModel<T>>(this, "selectionModel");
    private ObjectProperty<FocusModel<T>> focusModel;
    private ObjectProperty<Orientation> orientation;
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory;
    private BooleanProperty editable;
    private ReadOnlyIntegerWrapper editingIndex;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditStart;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditCommit;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditCancel;
    private static final String DEFAULT_STYLE_CLASS = "list-view";
    private static final String PSEUDO_CLASS_VERTICAL = "vertical";
    private static final String PSEUDO_CLASS_HORIZONTAL = "horizontal";
    private static final long VERTICAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("vertical");
    private static final long HORIZONTAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("horizontal");

    public static <T> EventType<EditEvent<T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    public ListView() {
        this(FXCollections.observableArrayList());
    }

    public ListView(ObservableList<T> observableList) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setItems(observableList);
        this.setSelectionModel(new ListViewBitSetSelectionModel(this));
        this.setFocusModel(new ListViewFocusModel(this));
        this.setOnEditCommit(this.DEFAULT_EDIT_COMMIT_HANDLER);
    }

    public final void setItems(ObservableList<T> observableList) {
        this.itemsProperty().set(observableList);
    }

    public final ObservableList<T> getItems() {
        return this.items == null ? null : (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        if (this.items == null) {
            this.items = new SimpleObjectProperty<ObservableList<T>>(this, "items"){
                WeakReference<ObservableList<T>> oldItemsRef;

                @Override
                protected void invalidated() {
                    ObservableList observableList;
                    ObservableList observableList2 = observableList = this.oldItemsRef == null ? null : (ObservableList)this.oldItemsRef.get();
                    if (ListView.this.getSelectionModel() instanceof ListViewBitSetSelectionModel) {
                        ((ListViewBitSetSelectionModel)ListView.this.getSelectionModel()).updateItemsObserver(observableList, ListView.this.getItems());
                    }
                    if (ListView.this.getFocusModel() instanceof ListViewFocusModel) {
                        ((ListViewFocusModel)ListView.this.getFocusModel()).updateItemsObserver(observableList, ListView.this.getItems());
                    }
                    if (ListView.this.getSkin() instanceof ListViewSkin) {
                        ListViewSkin listViewSkin = (ListViewSkin)ListView.this.getSkin();
                        listViewSkin.updateListViewItems();
                    }
                    this.oldItemsRef = new WeakReference(ListView.this.getItems());
                }
            };
        }
        return this.items;
    }

    public final void setSelectionModel(MultipleSelectionModel<T> multipleSelectionModel) {
        this.selectionModelProperty().set(multipleSelectionModel);
    }

    public final MultipleSelectionModel<T> getSelectionModel() {
        return this.selectionModel == null ? null : (MultipleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setFocusModel(FocusModel<T> focusModel) {
        this.focusModelProperty().set(focusModel);
    }

    public final FocusModel<T> getFocusModel() {
        return this.focusModel == null ? null : (FocusModel)this.focusModel.get();
    }

    public final ObjectProperty<FocusModel<T>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<FocusModel<T>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.VERTICAL : (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(Orientation.VERTICAL){

                @Override
                public void invalidated() {
                    ListView.this.impl_pseudoClassStateChanged(ListView.PSEUDO_CLASS_VERTICAL);
                    ListView.this.impl_pseudoClassStateChanged(ListView.PSEUDO_CLASS_HORIZONTAL);
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> callback) {
        this.cellFactoryProperty().set(callback);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty<Callback<ListView<T>, ListCell<T>>>(this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setEditable(boolean bl) {
        this.editableProperty().set(bl);
    }

    public final boolean isEditable() {
        return this.editable == null ? false : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingIndex(int n) {
        this.editingIndexPropertyImpl().set(n);
    }

    public final int getEditingIndex() {
        return this.editingIndex == null ? -1 : this.editingIndex.get();
    }

    public final ReadOnlyIntegerProperty editingIndexProperty() {
        return this.editingIndexPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper editingIndexPropertyImpl() {
        if (this.editingIndex == null) {
            this.editingIndex = new ReadOnlyIntegerWrapper(this, "editingIndex", -1);
        }
        return this.editingIndex;
    }

    public final void setOnEditStart(EventHandler<EditEvent<T>> eventHandler) {
        this.onEditStartProperty().set(eventHandler);
    }

    public final EventHandler<EditEvent<T>> getOnEditStart() {
        return this.onEditStart == null ? null : (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            this.onEditStart = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    ListView.this.setEventHandler(ListView.editStartEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "onEditStart";
                }
            };
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<EditEvent<T>> eventHandler) {
        this.onEditCommitProperty().set(eventHandler);
    }

    public final EventHandler<EditEvent<T>> getOnEditCommit() {
        return this.onEditCommit == null ? null : (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            this.onEditCommit = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    ListView.this.setEventHandler(ListView.editCommitEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "onEditCommit";
                }
            };
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<EditEvent<T>> eventHandler) {
        this.onEditCancelProperty().set(eventHandler);
    }

    public final EventHandler<EditEvent<T>> getOnEditCancel() {
        return this.onEditCancel == null ? null : (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            this.onEditCancel = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    ListView.this.setEventHandler(ListView.editCancelEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "onEditCancel";
                }
            };
        }
        return this.onEditCancel;
    }

    public void edit(int n) {
        if (!this.isEditable()) {
            return;
        }
        this.setEditingIndex(n);
    }

    public void scrollTo(int n) {
        this.getProperties().put("VirtualContainerBase.scrollToIndexCentered", n);
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return ListView.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.getOrientation() == Orientation.VERTICAL ? VERTICAL_PSEUDOCLASS_STATE : HORIZONTAL_PSEUDOCLASS_STATE;
    }

    public static class EditEvent<T>
    extends Event {
        private final T newValue;
        private final int editIndex;

        public EditEvent(ListView<T> listView, EventType<? extends EditEvent<T>> eventType, T t, int n) {
            super(listView, Event.NULL_SOURCE_TARGET, eventType);
            this.editIndex = n;
            this.newValue = t;
        }

        @Override
        public ListView<T> getSource() {
            return (ListView)super.getSource();
        }

        public int getIndex() {
            return this.editIndex;
        }

        public T getNewValue() {
            return this.newValue;
        }

        @Override
        public String toString() {
            return "ListViewEditEvent [ newValue: " + this.getNewValue() + ", ListView: " + this.getSource() + " ]";
        }
    }

    static class ListViewBitSetSelectionModel<T>
    extends MultipleSelectionModelBase<T> {
        private final ListChangeListener<T> itemsContentObserver = new ListChangeListener<T>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends T> change) {
                while (change.next()) {
                    int n;
                    if (ListViewBitSetSelectionModel.this.listView.getItems() == null || ListViewBitSetSelectionModel.this.listView.getItems().isEmpty()) {
                        ListViewBitSetSelectionModel.this.setSelectedIndex(-1);
                        ListViewBitSetSelectionModel.this.focus(-1);
                    } else if (ListViewBitSetSelectionModel.this.getSelectedIndex() == -1 && ListViewBitSetSelectionModel.this.getSelectedItem() != null && (n = ListViewBitSetSelectionModel.this.listView.getItems().indexOf(ListViewBitSetSelectionModel.this.getSelectedItem())) != -1) {
                        ListViewBitSetSelectionModel.this.setSelectedIndex(n);
                    }
                    ListViewBitSetSelectionModel.this.updateSelection(change);
                }
            }
        };
        private final ChangeListener<ObservableList<T>> itemsObserver = new ChangeListener<ObservableList<T>>(){

            @Override
            public void changed(ObservableValue<? extends ObservableList<T>> observableValue, ObservableList<T> observableList, ObservableList<T> observableList2) {
                ListViewBitSetSelectionModel.this.updateItemsObserver(observableList, observableList2);
            }
        };
        private WeakListChangeListener weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);
        private WeakChangeListener weakItemsObserver = new WeakChangeListener<ObservableList<T>>(this.itemsObserver);
        private final ListView<T> listView;
        private int previousModelSize = 0;

        public ListViewBitSetSelectionModel(ListView<T> listView) {
            if (listView == null) {
                throw new IllegalArgumentException("ListView can not be null");
            }
            this.listView = listView;
            this.listView.itemsProperty().addListener(this.weakItemsObserver);
            if (listView.getItems() != null) {
                this.listView.getItems().addListener(this.weakItemsContentObserver);
            }
        }

        private void updateItemsObserver(ObservableList<T> observableList, ObservableList<T> observableList2) {
            if (observableList != null) {
                observableList.removeListener(this.weakItemsContentObserver);
            }
            if (observableList2 != null) {
                observableList2.addListener(this.weakItemsContentObserver);
            }
            this.setSelectedIndex(-1);
            this.focus(-1);
        }

        private void updateSelection(ListChangeListener.Change<? extends T> change) {
            change.reset();
            while (change.next()) {
                int n;
                int n2;
                if (change.wasReplaced()) {
                    if (change.getList().isEmpty()) {
                        this.clearSelection();
                        continue;
                    }
                    n2 = this.getSelectedIndex();
                    if (this.previousModelSize == change.getRemovedSize()) {
                        this.clearSelection();
                        continue;
                    }
                    if (n2 < this.getItemCount() && n2 >= 0) {
                        this.makeAtomic = true;
                        this.clearSelection(n2);
                        this.makeAtomic = false;
                        this.select(n2);
                        continue;
                    }
                    this.clearSelection();
                    continue;
                }
                if (change.wasAdded() || change.wasRemoved()) {
                    n2 = change.wasAdded() ? change.getAddedSize() : -change.getRemovedSize();
                    this.shiftSelection(change.getFrom(), n2);
                    continue;
                }
                if (!change.wasPermutated()) continue;
                n2 = change.getTo() - change.getFrom();
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n2);
                for (int i = change.getFrom(); i < change.getTo(); ++i) {
                    hashMap.put(i, change.getPermutation(i));
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getSelectedIndices());
                this.clearSelection();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.getSelectedIndices().size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    n = (Integer)arrayList.get(i);
                    if (!hashMap.containsKey(n)) continue;
                    Integer n3 = (Integer)hashMap.get(n);
                    arrayList2.add(n3);
                }
                if (arrayList2.isEmpty()) continue;
                if (arrayList2.size() == 1) {
                    this.select((Integer)arrayList2.get(0));
                    continue;
                }
                int[] nArray = new int[arrayList2.size() - 1];
                for (n = 0; n < arrayList2.size() - 1; ++n) {
                    nArray[n] = (Integer)arrayList2.get(n + 1);
                }
                this.selectIndices((Integer)arrayList2.get(0), nArray);
            }
            this.previousModelSize = this.getItemCount();
        }

        @Override
        protected void focus(int n) {
            if (this.listView.getFocusModel() == null) {
                return;
            }
            this.listView.getFocusModel().focus(n);
        }

        @Override
        protected int getFocusedIndex() {
            if (this.listView.getFocusModel() == null) {
                return -1;
            }
            return this.listView.getFocusModel().getFocusedIndex();
        }

        @Override
        protected int getItemCount() {
            return this.listView.getItems() == null ? -1 : this.listView.getItems().size();
        }

        @Override
        public T getModelItem(int n) {
            if (this.listView.getItems() == null) {
                return null;
            }
            if (n < 0 || n >= this.getItemCount()) {
                return null;
            }
            return (T)this.listView.getItems().get(n);
        }
    }

    static class ListViewFocusModel<T>
    extends FocusModel<T> {
        private final ListView<T> listView;
        private ChangeListener<ObservableList<T>> itemsListener = new ChangeListener<ObservableList<T>>(){

            @Override
            public void changed(ObservableValue<? extends ObservableList<T>> observableValue, ObservableList<T> observableList, ObservableList<T> observableList2) {
                ListViewFocusModel.this.updateItemsObserver(observableList, observableList2);
            }
        };
        private WeakChangeListener<ObservableList<T>> weakItemsListener = new WeakChangeListener<ObservableList<ObservableList<T>>>(this.itemsListener);
        private final ListChangeListener<T> itemsContentListener = new ListChangeListener<T>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends T> change) {
                change.next();
                int n = change.getFrom();
                if (ListViewFocusModel.this.getFocusedIndex() == -1 || n > ListViewFocusModel.this.getFocusedIndex()) {
                    return;
                }
                change.reset();
                boolean bl = false;
                boolean bl2 = false;
                int n2 = 0;
                int n3 = 0;
                while (change.next()) {
                    bl |= change.wasAdded();
                    bl2 |= change.wasRemoved();
                    n2 += change.getAddedSize();
                    n3 += change.getRemovedSize();
                }
                if (bl && !bl2) {
                    ListViewFocusModel.this.focus(ListViewFocusModel.this.getFocusedIndex() + n2);
                } else if (!bl && bl2) {
                    ListViewFocusModel.this.focus(ListViewFocusModel.this.getFocusedIndex() - n3);
                }
            }
        };
        private WeakListChangeListener<T> weakItemsContentListener = new WeakListChangeListener<T>(this.itemsContentListener);

        public ListViewFocusModel(ListView<T> listView) {
            if (listView == null) {
                throw new IllegalArgumentException("ListView can not be null");
            }
            this.listView = listView;
            this.listView.itemsProperty().addListener(this.weakItemsListener);
            if (listView.getItems() != null) {
                this.listView.getItems().addListener(this.weakItemsContentListener);
            }
        }

        private void updateItemsObserver(ObservableList<T> observableList, ObservableList<T> observableList2) {
            if (observableList != null) {
                observableList.removeListener(this.weakItemsContentListener);
            }
            if (observableList2 != null) {
                observableList2.addListener(this.weakItemsContentListener);
            }
        }

        @Override
        protected int getItemCount() {
            return this.isEmpty() ? -1 : this.listView.getItems().size();
        }

        @Override
        protected T getModelItem(int n) {
            if (this.isEmpty()) {
                return null;
            }
            if (n < 0 || n >= this.getItemCount()) {
                return null;
            }
            return (T)this.listView.getItems().get(n);
        }

        private boolean isEmpty() {
            return this.listView == null || this.listView.getItems() == null;
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<ListView, Orientation> ORIENTATION = new StyleableProperty<ListView, Orientation>("-fx-orientation", new EnumConverter(Orientation.class), Orientation.VERTICAL){

            @Override
            public Orientation getInitialValue(ListView listView) {
                return listView.getOrientation();
            }

            @Override
            public boolean isSettable(ListView listView) {
                return listView.orientation == null || !listView.orientation.isBound();
            }

            @Override
            public WritableValue<Orientation> getWritableValue(ListView listView) {
                return listView.orientationProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

