/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.apache.fop.render.afp.extensions.AbstractAFPExtensionObject;
import org.apache.fop.render.afp.extensions.ExtensionPlacement;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class AFPPageSetupElement
extends AbstractAFPExtensionObject {
    private static final String ATT_ENCODING = "encoding";
    private static final String ATT_SRC = "src";

    public AFPPageSetupElement(FONode parent, String name) {
        super(parent, name);
    }

    private AFPPageSetup getPageSetupAttachment() {
        return (AFPPageSetup)this.getExtensionAttachment();
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        if ("tag-logical-element".equals(this.getLocalName())) {
            if (this.parent.getNameId() != 68 && this.parent.getNameId() != 53) {
                this.invalidChildError(this.getLocator(), this.parent.getName(), this.getNamespaceURI(), this.getName(), "rule.childOfPageSequenceOrSPM");
            }
        } else if (this.parent.getNameId() != 68 && this.parent.getNameId() != 53 && this.parent.getNameId() != 13) {
            this.invalidChildError(this.getLocator(), this.parent.getName(), this.getNamespaceURI(), this.getName(), "rule.childOfSPMorPSorDeclarations");
        }
    }

    protected void characters(char[] data, int start, int length, PropertyList pList, Locator locator) throws FOPException {
        StringBuffer sb = new StringBuffer();
        AFPPageSetup pageSetup = this.getPageSetupAttachment();
        if (pageSetup.getContent() != null) {
            sb.append(pageSetup.getContent());
        }
        sb.append(data, start, length);
        pageSetup.setContent(sb.toString());
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        String attr;
        super.processNode(elementName, locator, attlist, propertyList);
        AFPPageSetup pageSetup = this.getPageSetupAttachment();
        if ("include-page-segment".equals(elementName)) {
            attr = attlist.getValue(ATT_SRC);
            if (attr != null && attr.length() > 0) {
                pageSetup.setValue(attr);
            } else {
                this.missingPropertyError(ATT_SRC);
            }
        } else if ("tag-logical-element".equals(elementName)) {
            attr = attlist.getValue("value");
            if (attr != null && attr.length() > 0) {
                pageSetup.setValue(attr);
            } else {
                this.missingPropertyError("value");
            }
            attr = attlist.getValue(ATT_ENCODING);
            if (attr != null) {
                try {
                    pageSetup.setEncoding(Integer.parseInt(attr));
                }
                catch (NumberFormatException nfe) {
                    this.invalidPropertyValueError(ATT_ENCODING, attr, nfe);
                }
            }
        }
        String placement = attlist.getValue("placement");
        if (placement != null && placement.length() > 0) {
            pageSetup.setPlacement(ExtensionPlacement.fromXMLValue(placement));
        }
    }

    protected ExtensionAttachment instantiateExtensionAttachment() {
        return new AFPPageSetup(this.getLocalName());
    }
}

