/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class CoordinateInfoViewer
extends JPanel {
    private transient HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private LatLonViewer referenceLatLonViewer;
    private LatLonViewer currentLatLonViewer;
    private DistanceViewer distanceViewer;
    private MapViewer mapViewer;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.referenceLatLonViewer = new LatLonViewer(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceLatLonViewer, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.currentLatLonViewer = new LatLonViewer(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentLatLonViewer, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.distanceViewer = new DistanceViewer(this.model);
        this.add((Component)this.distanceViewer, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mapViewer = new MapViewer(this.model);
        this.add((Component)this.mapViewer, gridBagConstraints);
        this.mapViewer.setZoomContolsVisible(false);
    }

    public CoordinateInfoViewer(HistoryBrowserModel historyBrowserModel) {
        CheckParameterUtil.ensureParameterNotNull(historyBrowserModel, "model");
        this.setModel(historyBrowserModel);
        this.build();
        this.registerAsChangeListener(historyBrowserModel);
    }

    protected void unregisterAsChangeListener(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.removeChangeListener(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.removeChangeListener(this.referenceInfoPanel);
        }
        if (this.currentLatLonViewer != null) {
            historyBrowserModel.removeChangeListener(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            historyBrowserModel.removeChangeListener(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            historyBrowserModel.removeChangeListener(this.distanceViewer);
        }
        if (this.mapViewer != null) {
            historyBrowserModel.removeChangeListener(this.mapViewer);
        }
    }

    protected void registerAsChangeListener(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.addChangeListener(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.addChangeListener(this.referenceInfoPanel);
        }
        if (this.currentLatLonViewer != null) {
            historyBrowserModel.addChangeListener(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            historyBrowserModel.addChangeListener(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            historyBrowserModel.addChangeListener(this.distanceViewer);
        }
        if (this.mapViewer != null) {
            historyBrowserModel.addChangeListener(this.mapViewer);
        }
    }

    public void setModel(HistoryBrowserModel historyBrowserModel) {
        if (this.model != null) {
            this.unregisterAsChangeListener(historyBrowserModel);
        }
        this.model = historyBrowserModel;
        if (this.model != null) {
            this.registerAsChangeListener(historyBrowserModel);
        }
    }

    public void setDisplayToFitMapMarkers() {
        this.mapViewer.setDisplayToFitMapMarkers();
    }

    private static JosmTextArea newTextArea() {
        JosmTextArea josmTextArea = new JosmTextArea();
        GuiHelper.setBackgroundReadable(josmTextArea, Color.WHITE);
        josmTextArea.setEditable(false);
        josmTextArea.setOpaque(true);
        josmTextArea.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        josmTextArea.setFont(UIManager.getFont("Label.font"));
        return josmTextArea;
    }

    static /* synthetic */ JosmTextArea access$000() {
        return CoordinateInfoViewer.newTextArea();
    }

    private static class DistanceViewer
    extends JPanel
    implements ChangeListener {
        private final JosmTextArea lblDistance = CoordinateInfoViewer.access$000();
        private final transient Updater updater;

        DistanceViewer(HistoryBrowserModel historyBrowserModel) {
            this.updater = new Updater(historyBrowserModel, PointInTimeType.REFERENCE_POINT_IN_TIME);
            this.build();
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Distance: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.lblDistance, gridBagConstraints);
        }

        protected void refresh() {
            Pair<LatLon, LatLon> pair = this.updater.getCoordinates();
            if (pair == null) {
                return;
            }
            LatLon latLon = (LatLon)pair.a;
            LatLon latLon2 = (LatLon)pair.b;
            if (latLon != null && latLon2 != null) {
                double d = latLon.greatCircleDistance(latLon2);
                GuiHelper.setBackgroundReadable(this.lblDistance, d > 0.0 ? TwoColumnDiff.Item.DiffItemType.CHANGED.getColor() : Color.WHITE);
                this.lblDistance.setText(NavigatableComponent.getDistText(d));
            } else {
                GuiHelper.setBackgroundReadable(this.lblDistance, latLon != latLon2 ? TwoColumnDiff.Item.DiffItemType.CHANGED.getColor() : Color.WHITE);
                this.lblDistance.setText(I18n.tr("(none)", new Object[0]));
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh();
        }
    }

    private static class MapViewer
    extends JMapViewer
    implements ChangeListener {
        private final transient Updater updater;

        MapViewer(HistoryBrowserModel historyBrowserModel) {
            this.updater = new Updater(historyBrowserModel, PointInTimeType.REFERENCE_POINT_IN_TIME);
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MapMarkerDot mapMarkerDot;
            Pair<LatLon, LatLon> pair = this.updater.getCoordinates();
            if (pair == null) {
                return;
            }
            this.removeAllMapMarkers();
            if (pair.a != null) {
                mapMarkerDot = new MapMarkerDot(((LatLon)pair.a).lat(), ((LatLon)pair.a).lon());
                mapMarkerDot.setBackColor(TwoColumnDiff.Item.DiffItemType.DELETED.getColor());
                this.addMapMarker(mapMarkerDot);
            }
            if (pair.b != null) {
                mapMarkerDot = new MapMarkerDot(((LatLon)pair.b).lat(), ((LatLon)pair.b).lon());
                mapMarkerDot.setBackColor(TwoColumnDiff.Item.DiffItemType.INSERTED.getColor());
                this.addMapMarker(mapMarkerDot);
            }
            this.setDisplayToFitMapMarkers();
        }
    }

    private static class LatLonViewer
    extends JPanel
    implements ChangeListener {
        private final JosmTextArea lblLat = CoordinateInfoViewer.access$000();
        private final JosmTextArea lblLon = CoordinateInfoViewer.access$000();
        private final transient Updater updater;
        private final Color modifiedColor;

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Latitude: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.lblLat, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Longitude: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.lblLon, gridBagConstraints);
        }

        LatLonViewer(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) {
            this.updater = new Updater(historyBrowserModel, pointInTimeType);
            this.modifiedColor = PointInTimeType.CURRENT_POINT_IN_TIME.equals((Object)pointInTimeType) ? TwoColumnDiff.Item.DiffItemType.INSERTED.getColor() : TwoColumnDiff.Item.DiffItemType.DELETED.getColor();
            this.build();
        }

        protected void refresh() {
            Pair<LatLon, LatLon> pair = this.updater.getCoordinates();
            if (pair == null) {
                return;
            }
            LatLon latLon = (LatLon)pair.a;
            LatLon latLon2 = (LatLon)pair.b;
            this.lblLat.setText(latLon != null ? latLon.latToString(CoordinateFormat.DECIMAL_DEGREES) : I18n.tr("(none)", new Object[0]));
            this.lblLon.setText(latLon != null ? latLon.lonToString(CoordinateFormat.DECIMAL_DEGREES) : I18n.tr("(none)", new Object[0]));
            if (latLon == latLon2 || latLon != null && latLon2 != null && latLon.lat() == latLon2.lat()) {
                GuiHelper.setBackgroundReadable(this.lblLat, Color.WHITE);
            } else {
                GuiHelper.setBackgroundReadable(this.lblLat, this.modifiedColor);
            }
            if (latLon == latLon2 || latLon != null && latLon2 != null && latLon.lon() == latLon2.lon()) {
                GuiHelper.setBackgroundReadable(this.lblLon, Color.WHITE);
            } else {
                GuiHelper.setBackgroundReadable(this.lblLon, this.modifiedColor);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh();
        }
    }

    private static class Updater {
        private final HistoryBrowserModel model;
        private final PointInTimeType role;

        protected Updater(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) {
            this.model = historyBrowserModel;
            this.role = pointInTimeType;
        }

        protected HistoryOsmPrimitive getPrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role);
        }

        protected HistoryOsmPrimitive getOppositePrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role.opposite());
        }

        protected final Pair<LatLon, LatLon> getCoordinates() {
            HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
            HistoryOsmPrimitive historyOsmPrimitive2 = this.getOppositePrimitive();
            if (!(historyOsmPrimitive instanceof HistoryNode)) {
                return null;
            }
            if (!(historyOsmPrimitive2 instanceof HistoryNode)) {
                return null;
            }
            HistoryNode historyNode = (HistoryNode)historyOsmPrimitive;
            HistoryNode historyNode2 = (HistoryNode)historyOsmPrimitive2;
            return Pair.create(historyNode.getCoords(), historyNode2.getCoords());
        }
    }
}

