/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.TimeStampUtils;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsViewPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final String TIME_STAMP_FORMAT_COMBOBOX_TOOL_TIP = Constant.messages.getString("options.display.timestamp.format.combobox.tooltip");
    private static final String TIME_STAMP_FORMAT_DATETIME = Constant.messages.getString("timestamp.format.datetime");
    private static final String TIME_STAMP_FORMAT_ISO8601 = Constant.messages.getString("timestamp.format.iso8601");
    private static final String TIME_STAMP_FORMAT_TIMEONLY = Constant.messages.getString("timestamp.format.timeonly");
    private JPanel panelMisc = null;
    private JCheckBox chkShowTabNames = null;
    private JCheckBox chkProcessImages = null;
    private JCheckBox chkShowMainToolbar = null;
    private JCheckBox chkAdvancedView = null;
    private JCheckBox chkAskOnExit = null;
    private JCheckBox chkWmUiHandling = null;
    private JCheckBox chkOutputTabTimeStamping = null;
    private JCheckBox chkShowSplashScreen = null;
    private JCheckBox scaleImages = null;
    private JCheckBox showLocalConnectRequestsCheckbox;
    private JComboBox<String> brkPanelViewSelect = null;
    private JComboBox<String> displaySelect = null;
    private JComboBox<ResponsePanelPositionUI> responsePanelPositionComboBox;
    private JComboBox<String> timeStampsFormatSelect = null;
    private JComboBox<String> fontName = null;
    private ZapNumberSpinner largeRequestSize = null;
    private ZapNumberSpinner largeResponseSize = null;
    private ZapNumberSpinner fontSize = null;
    private JLabel brkPanelViewLabel = null;
    private JLabel advancedViewLabel = null;
    private JLabel wmUiHandlingLabel = null;
    private JLabel askOnExitLabel = null;
    private JLabel displayLabel = null;
    private JLabel showMainToolbarLabel = null;
    private JLabel processImagesLabel = null;
    private JLabel showTabNamesLabel = null;
    private JLabel outputTabTimeStampLabel = null;
    private JLabel outputTabTimeStampExampleLabel = null;
    private JLabel showSplashScreenLabel = null;
    private JLabel largeRequestLabel = null;
    private JLabel largeResponseLabel = null;
    private JLabel fontExampleLabel = null;

    public OptionsViewPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("view.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelMisc.setSize(114, 132);
            }
            this.panelMisc.setName(Constant.messages.getString("view.options.misc.title"));
            this.displayLabel = new JLabel(Constant.messages.getString("view.options.label.display"));
            this.brkPanelViewLabel = new JLabel(Constant.messages.getString("view.options.label.brkPanelView"));
            this.advancedViewLabel = new JLabel(Constant.messages.getString("view.options.label.advancedview"));
            this.wmUiHandlingLabel = new JLabel(Constant.messages.getString("view.options.label.wmuihandler"));
            this.askOnExitLabel = new JLabel(Constant.messages.getString("view.options.label.askonexit"));
            this.showMainToolbarLabel = new JLabel(Constant.messages.getString("view.options.label.showMainToolbar"));
            this.processImagesLabel = new JLabel(Constant.messages.getString("view.options.label.processImages"));
            this.showTabNamesLabel = new JLabel(Constant.messages.getString("view.options.label.showTabNames"));
            this.outputTabTimeStampLabel = new JLabel(Constant.messages.getString("options.display.timestamp.format.outputtabtimestamps.label"));
            this.largeRequestLabel = new JLabel(Constant.messages.getString("view.options.label.largeRequestSize"));
            this.largeResponseLabel = new JLabel(Constant.messages.getString("view.options.label.largeResponseSize"));
            this.outputTabTimeStampExampleLabel = new JLabel(TimeStampUtils.currentDefaultFormattedTimeStamp());
            this.showSplashScreenLabel = new JLabel(Constant.messages.getString("view.options.label.showSplashScreen"));
            int n = 0;
            this.displayLabel.setLabelFor(this.getDisplaySelect());
            this.panelMisc.add((Component)this.displayLabel, LayoutHelper.getGBC(0, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getDisplaySelect(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel jLabel = new JLabel(Constant.messages.getString("view.options.label.responsepanelpos"));
            this.panelMisc.add((Component)jLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getResponsePanelPositionComboBox(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.brkPanelViewLabel.setLabelFor(this.getBrkPanelViewSelect());
            this.panelMisc.add((Component)this.brkPanelViewLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getBrkPanelViewSelect(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.largeRequestLabel.setLabelFor(this.getLargeRequestSize());
            this.panelMisc.add((Component)this.largeRequestLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getLargeRequestSize(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.largeResponseLabel.setLabelFor(this.getLargeResponseSize());
            this.panelMisc.add((Component)this.largeResponseLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getLargeResponseSize(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.advancedViewLabel.setLabelFor(this.getChkAdvancedView());
            this.panelMisc.add((Component)this.advancedViewLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkAdvancedView(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.wmUiHandlingLabel.setLabelFor(this.getChkWmUiHandling());
            this.panelMisc.add((Component)this.wmUiHandlingLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkWmUiHandling(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.askOnExitLabel.setLabelFor(this.getChkAskOnExit());
            this.panelMisc.add((Component)this.askOnExitLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkAskOnExit(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.showMainToolbarLabel.setLabelFor(this.getChkShowMainToolbar());
            this.panelMisc.add((Component)this.showMainToolbarLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkShowMainToolbar(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.processImagesLabel.setLabelFor(this.getChkProcessImages());
            this.panelMisc.add((Component)this.processImagesLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkProcessImages(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            Insets insets = new Insets(2, 2, 2, 2);
            String string = Constant.messages.getString("view.options.label.showlocalconnectrequests");
            JLabel jLabel2 = new JLabel(string);
            jLabel2.setLabelFor(this.getShowLocalConnectRequestsCheckbox());
            this.panelMisc.add((Component)jLabel2, LayoutHelper.getGBC(0, ++n, 1, 1.0, insets));
            this.panelMisc.add((Component)this.getShowLocalConnectRequestsCheckbox(), LayoutHelper.getGBC(1, n, 1, 1.0, insets));
            this.showTabNamesLabel.setLabelFor(this.getShowTabNames());
            this.panelMisc.add((Component)this.showTabNamesLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getShowTabNames(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.showSplashScreenLabel.setLabelFor(this.getShowSplashScreen());
            this.panelMisc.add((Component)this.showSplashScreenLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getShowSplashScreen(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.outputTabTimeStampLabel.setLabelFor(this.getChkOutputTabTimeStamps());
            this.panelMisc.add((Component)this.outputTabTimeStampLabel, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkOutputTabTimeStamps(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.outputTabTimeStampExampleLabel.setLabelFor(this.getTimeStampsFormatSelect());
            this.panelMisc.add(this.getTimeStampsFormatSelect(), LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.outputTabTimeStampExampleLabel, LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel jLabel3 = new JLabel(Constant.messages.getString("view.options.label.fontName"));
            jLabel3.setLabelFor(this.getFontName());
            this.panelMisc.add((Component)jLabel3, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getFontName(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel jLabel4 = new JLabel(Constant.messages.getString("view.options.label.fontSize"));
            jLabel4.setLabelFor(this.getFontSize());
            this.panelMisc.add((Component)jLabel4, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getFontSize(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel jLabel5 = new JLabel(Constant.messages.getString("view.options.label.fontExample"));
            jLabel5.setLabelFor(this.getFontExampleLabel());
            this.panelMisc.add((Component)jLabel5, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getFontExampleLabel(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel jLabel6 = new JLabel(Constant.messages.getString("view.options.label.scaleImages"));
            jLabel5.setLabelFor(this.getScaleImages());
            this.panelMisc.add((Component)jLabel6, LayoutHelper.getGBC(0, ++n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getScaleImages(), LayoutHelper.getGBC(1, n, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)new JLabel(""), LayoutHelper.getGBC(0, ++n, 1, 1.0, 1.0));
        }
        return this.panelMisc;
    }

    private JCheckBox getShowTabNames() {
        if (this.chkShowTabNames == null) {
            this.chkShowTabNames = new JCheckBox();
            this.chkShowTabNames.setVerticalAlignment(1);
            this.chkShowTabNames.setVerticalTextPosition(1);
        }
        return this.chkShowTabNames;
    }

    private JCheckBox getShowSplashScreen() {
        if (this.chkShowSplashScreen == null) {
            this.chkShowSplashScreen = new JCheckBox();
            this.chkShowSplashScreen.setVerticalAlignment(1);
            this.chkShowSplashScreen.setVerticalTextPosition(1);
        }
        return this.chkShowSplashScreen;
    }

    private JCheckBox getChkProcessImages() {
        if (this.chkProcessImages == null) {
            this.chkProcessImages = new JCheckBox();
            this.chkProcessImages.setVerticalAlignment(1);
            this.chkProcessImages.setVerticalTextPosition(1);
        }
        return this.chkProcessImages;
    }

    private JCheckBox getChkShowMainToolbar() {
        if (this.chkShowMainToolbar == null) {
            this.chkShowMainToolbar = new JCheckBox();
            this.chkShowMainToolbar.setVerticalAlignment(1);
            this.chkShowMainToolbar.setVerticalTextPosition(1);
        }
        return this.chkShowMainToolbar;
    }

    private JCheckBox getChkWmUiHandling() {
        if (this.chkWmUiHandling == null) {
            this.chkWmUiHandling = new JCheckBox();
            this.chkWmUiHandling.setVerticalAlignment(1);
            this.chkWmUiHandling.setVerticalTextPosition(1);
        }
        return this.chkWmUiHandling;
    }

    private JCheckBox getChkAskOnExit() {
        if (this.chkAskOnExit == null) {
            this.chkAskOnExit = new JCheckBox();
            this.chkAskOnExit.setVerticalAlignment(1);
            this.chkAskOnExit.setVerticalTextPosition(1);
        }
        return this.chkAskOnExit;
    }

    private JComboBox<String> getDisplaySelect() {
        if (this.displaySelect == null) {
            this.displaySelect = new JComboBox();
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.left"));
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.bottom"));
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.full"));
        }
        return this.displaySelect;
    }

    private JComboBox<ResponsePanelPositionUI> getResponsePanelPositionComboBox() {
        if (this.responsePanelPositionComboBox == null) {
            this.responsePanelPositionComboBox = new JComboBox();
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.tabs"), WorkbenchPanel.ResponsePanelPosition.TABS_SIDE_BY_SIDE));
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.sideBySide"), WorkbenchPanel.ResponsePanelPosition.PANELS_SIDE_BY_SIDE));
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.above"), WorkbenchPanel.ResponsePanelPosition.PANEL_ABOVE));
        }
        return this.responsePanelPositionComboBox;
    }

    private JComboBox<String> getBrkPanelViewSelect() {
        if (this.brkPanelViewSelect == null) {
            this.brkPanelViewSelect = new JComboBox();
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.toolbaronly"));
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.breakonly"));
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.both"));
        }
        return this.brkPanelViewSelect;
    }

    private JCheckBox getChkAdvancedView() {
        if (this.chkAdvancedView == null) {
            this.chkAdvancedView = new JCheckBox();
            this.chkAdvancedView.setVerticalAlignment(1);
            this.chkAdvancedView.setVerticalTextPosition(1);
        }
        return this.chkAdvancedView;
    }

    private JCheckBox getChkOutputTabTimeStamps() {
        if (this.chkOutputTabTimeStamping == null) {
            this.chkOutputTabTimeStamping = new JCheckBox();
            this.chkOutputTabTimeStamping.setVerticalAlignment(1);
            this.chkOutputTabTimeStamping.setVerticalTextPosition(1);
            this.chkOutputTabTimeStamping.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsViewPanel.this.timeStampsFormatSelect.setEnabled(itemEvent.getStateChange() == 1);
                }
            });
        }
        return this.chkOutputTabTimeStamping;
    }

    private JComboBox<String> getTimeStampsFormatSelect() {
        if (this.timeStampsFormatSelect == null) {
            String[] stringArray = new String[]{TIME_STAMP_FORMAT_DATETIME, TIME_STAMP_FORMAT_ISO8601, TIME_STAMP_FORMAT_TIMEONLY};
            this.timeStampsFormatSelect = new JComboBox<String>(stringArray);
            this.timeStampsFormatSelect.setToolTipText(TIME_STAMP_FORMAT_COMBOBOX_TOOL_TIP);
            this.timeStampsFormatSelect.setSelectedItem(this.getTimeStampsFormatSelect().getSelectedItem());
            this.timeStampsFormatSelect.setEditable(true);
            if (this.chkOutputTabTimeStamping.isSelected()) {
                this.timeStampsFormatSelect.setEnabled(true);
            } else {
                this.timeStampsFormatSelect.setEnabled(false);
            }
            this.timeStampsFormatSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)OptionsViewPanel.this.getTimeStampsFormatSelect().getSelectedItem();
                    OptionsViewPanel.this.outputTabTimeStampExampleLabel.setText(TimeStampUtils.currentFormattedTimeStamp(string));
                }
            });
        }
        return this.timeStampsFormatSelect;
    }

    private JCheckBox getShowLocalConnectRequestsCheckbox() {
        if (this.showLocalConnectRequestsCheckbox == null) {
            this.showLocalConnectRequestsCheckbox = new JCheckBox();
        }
        return this.showLocalConnectRequestsCheckbox;
    }

    private ZapNumberSpinner getLargeRequestSize() {
        if (this.largeRequestSize == null) {
            this.largeRequestSize = new ZapNumberSpinner(-1, 100000, Integer.MAX_VALUE);
        }
        return this.largeRequestSize;
    }

    private ZapNumberSpinner getLargeResponseSize() {
        if (this.largeResponseSize == null) {
            this.largeResponseSize = new ZapNumberSpinner(-1, 100000, Integer.MAX_VALUE);
        }
        return this.largeResponseSize;
    }

    private ZapNumberSpinner getFontSize() {
        if (this.fontSize == null) {
            this.fontSize = new ZapNumberSpinner(-1, 8, 100);
            if (!FontUtils.canChangeSize()) {
                this.fontSize.setEnabled(false);
            }
            this.fontSize.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    OptionsViewPanel.this.setExampleFont();
                }
            });
        }
        return this.fontSize;
    }

    private void setExampleFont() {
        String string = this.getFontName().getSelectedItem() == null ? "" : (String)this.getFontName().getSelectedItem();
        Font font = FontUtils.getFont(string);
        int n = this.getFontSize().getValue();
        if (n == -1) {
            n = FontUtils.getSystemDefaultFont().getSize();
        }
        this.getFontExampleLabel().setFont(font.deriveFont((float)n));
    }

    private JComboBox<String> getFontName() {
        if (this.fontName == null) {
            this.fontName = new JComboBox();
            this.fontName.setRenderer(new JComboBoxFontRenderer());
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.fontName.addItem(" ");
            for (String string : stringArray) {
                this.fontName.addItem(string);
            }
            if (!FontUtils.canChangeSize()) {
                this.fontName.setEnabled(false);
            }
            this.fontName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsViewPanel.this.setExampleFont();
                }
            });
        }
        return this.fontName;
    }

    private JLabel getFontExampleLabel() {
        if (this.fontExampleLabel == null) {
            this.fontExampleLabel = new JLabel(Constant.messages.getString("view.options.label.exampleText"));
            this.fontExampleLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        return this.fontExampleLabel;
    }

    private JCheckBox getScaleImages() {
        if (this.scaleImages == null) {
            this.scaleImages = new JCheckBox();
            if (!FontUtils.canChangeSize()) {
                this.scaleImages.setEnabled(false);
            }
        }
        return this.scaleImages;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        this.getShowTabNames().setSelected(optionsParam.getViewParam().getShowTabNames());
        this.getShowSplashScreen().setSelected(optionsParam.getViewParam().isShowSplashScreen());
        this.getChkProcessImages().setSelected(optionsParam.getViewParam().getProcessImages() > 0);
        this.displaySelect.setSelectedIndex(optionsParam.getViewParam().getDisplayOption());
        this.selectResponstPanelPosition(optionsParam.getViewParam().getResponsePanelPosition());
        this.brkPanelViewSelect.setSelectedIndex(optionsParam.getViewParam().getBrkPanelViewOption());
        this.getChkShowMainToolbar().setSelected(optionsParam.getViewParam().isShowMainToolbar());
        this.chkAdvancedView.setSelected(optionsParam.getViewParam().getAdvancedViewOption() > 0);
        this.chkAskOnExit.setSelected(optionsParam.getViewParam().getAskOnExitOption() > 0);
        this.chkWmUiHandling.setSelected(optionsParam.getViewParam().getWmUiHandlingOption() > 0);
        this.getChkOutputTabTimeStamps().setSelected(optionsParam.getViewParam().isOutputTabTimeStampingEnabled());
        this.timeStampsFormatSelect.setSelectedItem(optionsParam.getViewParam().getOutputTabTimeStampsFormat());
        this.getShowLocalConnectRequestsCheckbox().setSelected(optionsParam.getViewParam().isShowLocalConnectRequests());
        this.largeRequestSize.setValue(optionsParam.getViewParam().getLargeRequestSize());
        this.largeResponseSize.setValue(optionsParam.getViewParam().getLargeResponseSize());
        this.getFontSize().setValue(optionsParam.getViewParam().getFontSize());
        this.getFontName().setSelectedItem(optionsParam.getViewParam().getFontName());
        this.getScaleImages().setSelected(optionsParam.getViewParam().isScaleImages());
    }

    private void selectResponstPanelPosition(String string) {
        for (int i = 0; i < this.getResponsePanelPositionComboBox().getItemCount(); ++i) {
            ResponsePanelPositionUI responsePanelPositionUI = this.getResponsePanelPositionComboBox().getItemAt(i);
            if (!responsePanelPositionUI.getPosition().name().equals(string)) continue;
            this.getResponsePanelPositionComboBox().setSelectedIndex(i);
            break;
        }
        if (this.getResponsePanelPositionComboBox().getSelectedIndex() == -1) {
            this.getResponsePanelPositionComboBox().setSelectedIndex(0);
        }
    }

    @Override
    public void validateParam(Object object) {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        optionsParam.getViewParam().setShowTabNames(this.getShowTabNames().isSelected());
        optionsParam.getViewParam().setShowSplashScreen(this.getShowSplashScreen().isSelected());
        optionsParam.getViewParam().setProcessImages(this.getChkProcessImages().isSelected() ? 1 : 0);
        optionsParam.getViewParam().setDisplayOption(this.displaySelect.getSelectedIndex());
        ResponsePanelPositionUI responsePanelPositionUI = (ResponsePanelPositionUI)this.getResponsePanelPositionComboBox().getSelectedItem();
        optionsParam.getViewParam().setResponsePanelPosition(responsePanelPositionUI.getPosition().name());
        optionsParam.getViewParam().setBrkPanelViewOption(this.brkPanelViewSelect.getSelectedIndex());
        optionsParam.getViewParam().setShowMainToolbar(this.getChkShowMainToolbar().isSelected());
        optionsParam.getViewParam().setAdvancedViewOption(this.getChkAdvancedView().isSelected() ? 1 : 0);
        optionsParam.getViewParam().setAskOnExitOption(this.getChkAskOnExit().isSelected() ? 1 : 0);
        optionsParam.getViewParam().setWmUiHandlingOption(this.getChkWmUiHandling().isSelected() ? 1 : 0);
        optionsParam.getViewParam().setOutputTabTimeStampingEnabled(this.getChkOutputTabTimeStamps().isSelected());
        optionsParam.getViewParam().setOutputTabTimeStampsFormat((String)this.getTimeStampsFormatSelect().getSelectedItem());
        optionsParam.getViewParam().setShowLocalConnectRequests(this.getShowLocalConnectRequestsCheckbox().isSelected());
        optionsParam.getViewParam().setLargeRequestSize(this.getLargeRequestSize().getValue());
        optionsParam.getViewParam().setLargeResponseSize(this.getLargeResponseSize().getValue());
        optionsParam.getViewParam().setFontSize(this.getFontSize().getValue());
        optionsParam.getViewParam().setFontName((String)this.getFontName().getSelectedItem());
        optionsParam.getViewParam().setScaleImages(this.getScaleImages().isSelected());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.view";
    }

    private static class ResponsePanelPositionUI {
        private final String name;
        private final WorkbenchPanel.ResponsePanelPosition position;

        public ResponsePanelPositionUI(String string, WorkbenchPanel.ResponsePanelPosition responsePanelPosition) {
            this.name = string;
            this.position = responsePanelPosition;
        }

        public WorkbenchPanel.ResponsePanelPosition getPosition() {
            return this.position;
        }

        public String toString() {
            return this.name;
        }
    }

    private class JComboBoxFontRenderer
    extends BasicComboBoxRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private JComboBoxFontRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Font font = FontUtils.getFont((String)object);
            if (font != null) {
                jLabel.setFont(FontUtils.getFont((String)object));
            } else {
                jLabel.setFont(FontUtils.getFont(FontUtils.Size.standard));
            }
            return jLabel;
        }
    }
}

