/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSStyleSheetImpl;
import com.sun.webpane.webkit.dom.MediaListImpl;
import com.sun.webpane.webkit.dom.NodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class StyleSheetImpl
implements StyleSheet {
    protected final long peer;
    private static final int TYPE_CSSStyleSheet = 1;

    StyleSheetImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static StyleSheet create(long peer) {
        if (peer == 0L) {
            return null;
        }
        switch (StyleSheetImpl.getCPPTypeImpl(peer)) {
            case 1: {
                return new CSSStyleSheetImpl(peer);
            }
        }
        return new StyleSheetImpl(peer);
    }

    public boolean equals(Object that) {
        return that instanceof StyleSheetImpl && this.peer == ((StyleSheetImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(StyleSheet arg) {
        return arg == null ? 0L : ((StyleSheetImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    private static native int getCPPTypeImpl(long var0);

    static StyleSheet getImpl(long peer) {
        return StyleSheetImpl.create(peer);
    }

    @Override
    public String getType() {
        return StyleSheetImpl.getTypeImpl(this.getPeer());
    }

    static native String getTypeImpl(long var0);

    @Override
    public boolean getDisabled() {
        return StyleSheetImpl.getDisabledImpl(this.getPeer());
    }

    static native boolean getDisabledImpl(long var0);

    @Override
    public void setDisabled(boolean value) {
        StyleSheetImpl.setDisabledImpl(this.getPeer(), value);
    }

    static native void setDisabledImpl(long var0, boolean var2);

    @Override
    public Node getOwnerNode() {
        return NodeImpl.getImpl(StyleSheetImpl.getOwnerNodeImpl(this.getPeer()));
    }

    static native long getOwnerNodeImpl(long var0);

    @Override
    public StyleSheet getParentStyleSheet() {
        return StyleSheetImpl.getImpl(StyleSheetImpl.getParentStyleSheetImpl(this.getPeer()));
    }

    static native long getParentStyleSheetImpl(long var0);

    @Override
    public String getHref() {
        return StyleSheetImpl.getHrefImpl(this.getPeer());
    }

    static native String getHrefImpl(long var0);

    @Override
    public String getTitle() {
        return StyleSheetImpl.getTitleImpl(this.getPeer());
    }

    static native String getTitleImpl(long var0);

    @Override
    public MediaList getMedia() {
        return MediaListImpl.getImpl(StyleSheetImpl.getMediaImpl(this.getPeer()));
    }

    static native long getMediaImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            StyleSheetImpl.dispose(this.peer);
        }
    }
}

