#ifndef _EFL_CANVAS_TEXT_CURSOR_EO_LEGACY_H_
#define _EFL_CANVAS_TEXT_CURSOR_EO_LEGACY_H_

#ifndef _EFL_CANVAS_TEXT_CURSOR_EO_CLASS_TYPE
#define _EFL_CANVAS_TEXT_CURSOR_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Text_Cursor;

#endif

#ifndef _EFL_CANVAS_TEXT_CURSOR_EO_TYPES
#define _EFL_CANVAS_TEXT_CURSOR_EO_TYPES

typedef enum
{
  EFL_CANVAS_TEXT_CURSOR_TYPE_BEFORE = 0,
  EFL_CANVAS_TEXT_CURSOR_TYPE_UNDER
} Efl_Canvas_Text_Cursor_Type;


#endif

/**
 * @brief Sets position of cursor to given pos.
 *
 * @param[in] position Position in the text to move the cursor.
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI void evas_textblock_cursor_pos_set(Efl_Canvas_Text_Cursor *obj, int position);

/**
 * @brief Sets position of cursor to given pos.
 *
 * @return Position in the text to move the cursor.
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI int evas_textblock_cursor_pos_get(const Efl_Canvas_Text_Cursor *obj);

/** Deletes a single character from position pointed by given cursor.
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI void evas_textblock_cursor_char_delete(Efl_Canvas_Text_Cursor *obj);

/** Sets the cursor to the start of the first text node
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI void evas_textblock_cursor_paragraph_first(Efl_Canvas_Text_Cursor *obj);

/** Sets the cursor to the end of the last text node
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI void evas_textblock_cursor_paragraph_last(Efl_Canvas_Text_Cursor *obj);

/** Go to the first char in the node the cursor is pointing on.
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI void evas_textblock_cursor_paragraph_char_first(Efl_Canvas_Text_Cursor *obj);

/** Go to the last char in a text node.
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI void evas_textblock_cursor_paragraph_char_last(Efl_Canvas_Text_Cursor *obj);

/** Go to the start of the current line
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI void evas_textblock_cursor_line_char_first(Efl_Canvas_Text_Cursor *obj);

/** Go to the end of the current line
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI void evas_textblock_cursor_line_char_last(Efl_Canvas_Text_Cursor *obj);

/**
 * @brief Compares two cursors.
 *
 * Note that 0 will be returned if they are cursors of different textblock
 * objects.
 *
 * See @ref evas_textblock_cursor_equal for a faster equality check.
 *
 * @param[in] cur The second cursor.
 *
 * @return -1 if cur1 < cur2, 0 if cur1 == cur2, 1 otherwise.
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI int evas_textblock_cursor_compare(const Efl_Canvas_Text_Cursor *obj, const Efl_Canvas_Text_Cursor *cur);

/**
 * @brief Checks if two cursors are equal
 *
 * This is faster than @ref evas_textblock_cursor_compare so it should be used
 * if all we care about is equality.
 *
 * @param[in] cur The second cursor.
 *
 * @return @c true if equal
 *
 * @since 1.18
 *
 * @ingroup Efl_Canvas_Text_Cursor
 */
EAPI Eina_Bool evas_textblock_cursor_equal(const Efl_Canvas_Text_Cursor *obj, const Efl_Canvas_Text_Cursor *cur);

#endif
