/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.lang.reflect.Constructor;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.IgnoredBuilder;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.runner.Runner;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.slf4j.LoggerFactory;

public class AllExceptIgnoredTestRunnerBuilder
extends AllDefaultPossibilitiesBuilder {
    public AllExceptIgnoredTestRunnerBuilder() {
        super(true);
    }

    protected IgnoredBuilder ignoredBuilder() {
        return new IgnoredIgnoredBuilder();
    }

    protected JUnit4Builder junit4Builder() {
        return new FallbackJUnit4Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IgnoredIgnoredBuilder
    extends IgnoredBuilder {
        private IgnoredIgnoredBuilder() {
        }

        public Runner runnerForClass(Class<?> testClass) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FallbackJUnit4Builder
    extends JUnit4Builder {
        private FallbackJUnit4Builder() {
        }

        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            try {
                return new BlockJUnit4ClassRunner(testClass);
            }
            catch (Throwable t) {
                try {
                    Class<?> runnerClass = Thread.currentThread().getContextClassLoader().loadClass("org.junit.internal.runners.JUnit4ClassRunner");
                    Constructor<?> constructor = runnerClass.getConstructor(Class.class);
                    return (Runner)constructor.newInstance(testClass);
                }
                catch (Throwable e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Unable to load JUnit4 runner to calculate Ignored test cases", e);
                    return null;
                }
            }
        }
    }
}

