/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.repository.internal.LocalSnapshotMetadata;
import org.sonatype.aether.ConfigurationProperties;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.MetadataGenerator;
import org.sonatype.aether.installation.InstallRequest;
import org.sonatype.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalSnapshotMetadataGenerator
implements MetadataGenerator {
    private Map<Object, LocalSnapshotMetadata> snapshots;
    private final boolean legacyFormat;

    public LocalSnapshotMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this.legacyFormat = ConfigurationProperties.get((Map)session.getConfigProperties(), (String)"maven.metadata.legacy", (boolean)false);
        this.snapshots = new LinkedHashMap<Object, LocalSnapshotMetadata>();
    }

    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = LocalSnapshotMetadata.getKey(artifact);
            LocalSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new LocalSnapshotMetadata(artifact, this.legacyFormat);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return Collections.emptyList();
    }

    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return this.snapshots.values();
    }
}

