/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal;

import org.gradle.api.Transformer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcomeAssociator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByTypeAndCharacteristicBuildOutcomeAssociator<T extends BuildOutcome>
implements BuildOutcomeAssociator {
    private final Class<? extends T> type;
    private final Transformer<?, T> characteristicTransformer;

    public ByTypeAndCharacteristicBuildOutcomeAssociator(Class<? extends T> type, Transformer<?, T> characteristicTransformer) {
        this.type = type;
        this.characteristicTransformer = characteristicTransformer;
    }

    @Override
    public Class<? extends BuildOutcome> findAssociationType(BuildOutcome source, BuildOutcome target) {
        if (this.type.isInstance(source) && this.type.isInstance(target)) {
            Object fromCharacteristic = this.characteristicTransformer.transform(this.type.cast(source));
            Object toCharacteristic = this.characteristicTransformer.transform(this.type.cast(target));
            if (fromCharacteristic == null && toCharacteristic == null) {
                return this.type;
            }
            if (fromCharacteristic == null || toCharacteristic == null) {
                return null;
            }
            if (fromCharacteristic.equals(toCharacteristic)) {
                return this.type;
            }
            return null;
        }
        return null;
    }
}

