/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.health.DaemonHealthServices;

public class LowTenuredSpaceDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private final DaemonHealthServices healthServices;

    public LowTenuredSpaceDaemonExpirationStrategy(DaemonHealthServices healthServices) {
        this.healthServices = healthServices;
    }

    public DaemonExpirationResult checkExpiration(Daemon daemon) {
        if (this.healthServices.getDaemonStatus().isTenuredSpaceExhausted()) {
            return new DaemonExpirationResult(true, "JVM tenured space is exhausted");
        }
        return DaemonExpirationResult.DO_NOT_EXPIRE;
    }
}

