/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.gui;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class UserSettings
extends Properties {
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String HOME_DIRECTORY = "user.home";
    private static final String SETTINGS_FILE = System.getProperty("user.home") + "/.ili2c";
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";

    private UserSettings() {
    }

    protected static UserSettings createDefault() {
        UserSettings userSettings = new UserSettings();
        userSettings.setWorkingDirectory(System.getProperty(HOME_DIRECTORY));
        return userSettings;
    }

    private static Set getKeySet() {
        HashSet<String> set = new HashSet<String>();
        set.add(WORKING_DIRECTORY);
        return set;
    }

    public String getWorkingDirectory() {
        return this.getProperty(WORKING_DIRECTORY);
    }

    public static UserSettings load() {
        UserSettings userSettings = UserSettings.createDefault();
        try {
            FileInputStream inputStream = new FileInputStream(SETTINGS_FILE);
            UserSettings tmp = new UserSettings();
            tmp.load(inputStream);
            Iterator keys = UserSettings.getKeySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!tmp.containsKey(key)) continue;
                userSettings.setProperty(key, tmp.getProperty(key));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return userSettings;
    }

    public void save() {
        try {
            FileOutputStream outputStream = new FileOutputStream(SETTINGS_FILE);
            super.store(outputStream, "ili2c");
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.setProperty(WORKING_DIRECTORY, workingDirectory);
    }
}

