/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.parser;

import ch.interlis.ili2c.metamodel.ErrorListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public final class MetaObjectTopicScanner {
    String fileName;
    ErrorListener errorListener;
    Parser parser;
    boolean fatalErrorEncountered = false;
    Set topics = new HashSet();

    void reportException(Exception ex, int lineNumber) {
        ErrorListener.ErrorEvent theEvent = new ErrorListener.ErrorEvent(ex, this.fileName, lineNumber, 5);
        this.errorListener.error(theEvent);
    }

    public Set getTopics() {
        return this.topics;
    }

    public boolean parse(String fileName, ErrorListener errorListener) {
        this.fileName = fileName;
        this.errorListener = errorListener;
        ErrorListener.ErrorEvent theEvent = null;
        MyHandler myHandler = new MyHandler();
        try {
            String parserClass = "org.apache.xerces.parsers.SAXParser";
            this.parser = ParserFactory.makeParser(parserClass);
            this.parser.setDocumentHandler(myHandler);
            this.parser.setErrorHandler(myHandler);
            this.parser.parse("file:" + new File(fileName).getAbsolutePath());
        }
        catch (SAXParseException err) {
            theEvent = new ErrorListener.ErrorEvent(err.getMessage(), err.getSystemId(), err.getLineNumber(), 5);
            errorListener.error(theEvent);
            return false;
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            this.reportException(x, 0);
            return false;
        }
        catch (Exception t) {
            this.reportException(t, 0);
            return false;
        }
        return !this.fatalErrorEncountered;
    }

    class MyHandler
    extends HandlerBase {
        private int level = 0;
        private boolean inTransfer = false;
        private int TRANSFER_LEVEL = 1;
        private boolean inDataSection = false;
        private int DATASECTION_LEVEL = 2;
        private boolean inBasket = false;
        private int BASKET_LEVEL = 3;

        MyHandler() {
        }

        public void warning(SAXParseException ex) {
            MetaObjectTopicScanner.this.errorListener.error(new ErrorListener.ErrorEvent(ex.getMessage(), ex.getSystemId(), ex.getLineNumber(), 3));
        }

        public void error(SAXParseException ex) {
            MetaObjectTopicScanner.this.errorListener.error(new ErrorListener.ErrorEvent(ex.getMessage(), ex.getSystemId(), ex.getLineNumber(), 5));
        }

        public void fatalError(SAXParseException ex) {
            MetaObjectTopicScanner.this.fatalErrorEncountered = true;
            MetaObjectTopicScanner.this.errorListener.error(new ErrorListener.ErrorEvent(ex.getMessage(), ex.getSystemId(), ex.getLineNumber(), 5));
        }

        public void startElement(String name, AttributeList atts) {
            ++this.level;
            if (this.level == this.TRANSFER_LEVEL && name.equals("TRANSFER")) {
                this.inTransfer = true;
                return;
            }
            if (this.level == this.DATASECTION_LEVEL && this.inTransfer && name.equals("DATASECTION")) {
                this.inDataSection = true;
                return;
            }
            if (this.level == this.BASKET_LEVEL && this.inDataSection) {
                MetaObjectTopicScanner.this.topics.add(name);
            }
        }

        public void endElement(String name) {
            if (this.level == this.BASKET_LEVEL && this.inBasket) {
                this.inBasket = false;
            } else if (this.level == this.DATASECTION_LEVEL && this.inDataSection) {
                this.inDataSection = false;
            } else if (this.level == this.TRANSFER_LEVEL && this.inTransfer) {
                this.inTransfer = false;
            }
            --this.level;
        }
    }
}

