/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFProfile;
import org.apache.xmlgraphics.util.DateFormatUtil;

public class PDFInfo
extends PDFObject {
    private String producer;
    private String title = null;
    private String author = null;
    private String subject = null;
    private String keywords = null;
    private Date creationDate = null;
    private Date modDate = null;
    private String creator;

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String a) {
        this.author = a;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String k) {
        this.keywords = k;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date date) {
        this.modDate = date;
    }

    public byte[] toPDF() {
        PDFProfile profile = this.getDocumentSafely().getProfile();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(128);
        try {
            bout.write(PDFInfo.encode("<<\n"));
            if (this.title != null && this.title.length() > 0) {
                bout.write(PDFInfo.encode("/Title "));
                bout.write(this.encodeText(this.title));
                bout.write(PDFInfo.encode("\n"));
            } else {
                profile.verifyTitleAbsent();
            }
            if (this.author != null) {
                bout.write(PDFInfo.encode("/Author "));
                bout.write(this.encodeText(this.author));
                bout.write(PDFInfo.encode("\n"));
            }
            if (this.subject != null) {
                bout.write(PDFInfo.encode("/Subject "));
                bout.write(this.encodeText(this.subject));
                bout.write(PDFInfo.encode("\n"));
            }
            if (this.keywords != null) {
                bout.write(PDFInfo.encode("/Keywords "));
                bout.write(this.encodeText(this.keywords));
                bout.write(PDFInfo.encode("\n"));
            }
            if (this.creator != null) {
                bout.write(PDFInfo.encode("/Creator "));
                bout.write(this.encodeText(this.creator));
                bout.write(PDFInfo.encode("\n"));
            }
            bout.write(PDFInfo.encode("/Producer "));
            bout.write(this.encodeText(this.producer));
            bout.write(PDFInfo.encode("\n"));
            if (this.creationDate == null) {
                this.creationDate = new Date();
            }
            bout.write(PDFInfo.encode("/CreationDate "));
            bout.write(this.encodeString(PDFInfo.formatDateTime(this.creationDate)));
            bout.write(PDFInfo.encode("\n"));
            if (profile.isModDateRequired() && this.modDate == null) {
                this.modDate = this.creationDate;
            }
            if (this.modDate != null) {
                bout.write(PDFInfo.encode("/ModDate "));
                bout.write(this.encodeString(PDFInfo.formatDateTime(this.modDate)));
                bout.write(PDFInfo.encode("\n"));
            }
            if (profile.isPDFXActive()) {
                bout.write(PDFInfo.encode("/GTS_PDFXVersion "));
                bout.write(this.encodeString(profile.getPDFXMode().getName()));
                bout.write(PDFInfo.encode("\n"));
            }
            if (profile.isTrappedEntryRequired()) {
                bout.write(PDFInfo.encode("/Trapped /False\n"));
            }
            bout.write(PDFInfo.encode(">>"));
        }
        catch (IOException ioe) {
            log.error("Ignored I/O exception", ioe);
        }
        return bout.toByteArray();
    }

    protected static String formatDateTime(Date time, TimeZone tz) {
        return DateFormatUtil.formatPDFDate((Date)time, (TimeZone)tz);
    }

    protected static String formatDateTime(Date time) {
        return PDFInfo.formatDateTime(time, TimeZone.getDefault());
    }
}

