/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;

public class AlphaMonomer
extends Monomer {
    static final byte[] alphaOffsets = new byte[]{0};
    public ProteinStructure proteinStructure;
    protected P3 nitrogenHydrogenPoint;

    public boolean isProtein() {
        return true;
    }

    static Monomer validateAndAllocateA(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex, int[] specialAtomIndexes) {
        return firstIndex != lastIndex || specialAtomIndexes[2] != firstIndex ? null : new AlphaMonomer().set2(chain, group3, seqcode, firstIndex, lastIndex, alphaOffsets);
    }

    protected AlphaMonomer() {
    }

    boolean isAlphaMonomer() {
        return true;
    }

    public Structure getStructure() {
        return this.proteinStructure;
    }

    void setStructure(ProteinStructure ps) {
        this.proteinStructure = ps;
        if (this.proteinStructure == null) {
            this.nitrogenHydrogenPoint = null;
        }
    }

    @Override
    public void setStrucNo(int n) {
        if (this.proteinStructure != null) {
            this.proteinStructure.strucNo = n;
        }
    }

    @Override
    public STR getProteinStructureType() {
        return this.proteinStructure == null ? STR.NONE : this.proteinStructure.type;
    }

    public STR getProteinStructureSubType() {
        return this.proteinStructure == null ? STR.NONE : this.proteinStructure.subtype;
    }

    public int getStrucNo() {
        return this.proteinStructure != null ? this.proteinStructure.strucNo : 0;
    }

    @Override
    public boolean isHelix() {
        return this.proteinStructure != null && this.proteinStructure.type == STR.HELIX;
    }

    @Override
    public boolean isSheet() {
        return this.proteinStructure != null && this.proteinStructure.type == STR.SHEET;
    }

    public int setProteinStructureType(STR type, int monomerIndexCurrent) {
        if (this.proteinStructure != null) {
            this.proteinStructure.removeMonomer(this.monomerIndex);
        }
        if (monomerIndexCurrent < 0 || monomerIndexCurrent > 0 && this.monomerIndex == 0) {
            switch (type) {
                case HELIX: 
                case HELIXALPHA: 
                case HELIX310: 
                case HELIXPI: {
                    this.setStructure(new Helix((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, type));
                    break;
                }
                case SHEET: {
                    this.setStructure(new Sheet((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, type));
                    break;
                }
                case TURN: {
                    this.setStructure(new Turn((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1));
                    break;
                }
                case NONE: {
                    this.setStructure(null);
                }
            }
        } else {
            this.setStructure(this.bioPolymer.getProteinStructure(monomerIndexCurrent));
            if (this.proteinStructure != null) {
                this.proteinStructure.addMonomer(this.monomerIndex);
            }
        }
        return this.monomerIndex;
    }

    public final Atom getAtom(byte specialAtomID) {
        return specialAtomID == 2 ? this.getLeadAtom() : null;
    }

    public final P3 getAtomPoint(byte specialAtomID) {
        return specialAtomID == 2 ? this.getLeadAtom() : null;
    }

    @Override
    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        Atom atom2;
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        Atom atom1 = this.getLeadAtom();
        return atom1.isBonded(atom2 = possiblyPreviousMonomer.getLeadAtom()) || atom1.distance((T3)atom2) <= 4.2f;
    }

    @Override
    P3 getQuaternionFrameCenter(char qType) {
        return this.getQuaternionFrameCenterAlpha(qType);
    }

    public boolean isWithinStructure(STR type) {
        return this.proteinStructure != null && this.proteinStructure.type == type && this.proteinStructure.isWithin(this.monomerIndex);
    }

    protected P3 getQuaternionFrameCenterAlpha(char qType) {
        switch (qType) {
            case 'C': 
            case 'b': 
            case 'c': 
            case 'x': {
                return this.getLeadAtom();
            }
        }
        return null;
    }

    public Object getHelixData(int tokType, char qType, int mStep) {
        return this.getHelixData2(tokType, qType, mStep);
    }

    public Quat getQuaternion(char qType) {
        return this.getQuaternionAlpha(qType);
    }

    protected Quat getQuaternionAlpha(char qType) {
        if (this.monomerIndex < 0) {
            return null;
        }
        V3 vA = new V3();
        V3 vB = new V3();
        V3 vC = null;
        switch (qType) {
            default: {
                return null;
            }
            case 'b': 
            case 'c': 
            case 'x': 
        }
        if (this.monomerIndex == 0 || this.monomerIndex == this.bioPolymer.monomerCount - 1) {
            return null;
        }
        Atom ptCa = this.getLeadAtom();
        P3 ptCaNext = this.bioPolymer.getLeadPoint(this.monomerIndex + 1);
        P3 ptCaPrev = this.bioPolymer.getLeadPoint(this.monomerIndex - 1);
        vA.sub2((T3)ptCaNext, (T3)ptCa);
        vB.sub2((T3)ptCaPrev, (T3)ptCa);
        return Quat.getQuaternionFrameV((V3)vA, (V3)vB, vC, (boolean)false);
    }
}

