/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.ArrowPaintHelper;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.draw.MapPath2D;

public class WireframeMapRenderer
extends AbstractMapRenderer
implements Visitor {
    protected Color dfltWayColor;
    protected Color relationColor;
    protected Color untaggedWayColor;
    protected Color taggedColor;
    protected Color connectionColor;
    protected Color taggedConnectionColor;
    protected boolean showDirectionArrow;
    protected boolean showOnewayArrow;
    protected boolean showHeadArrowOnly;
    protected boolean showOrderNumber;
    protected boolean fillSelectedNode;
    protected boolean fillUnselectedNode;
    protected boolean fillTaggedNode;
    protected boolean fillConnectionNode;
    protected int selectedNodeSize;
    protected int unselectedNodeSize;
    protected int connectionNodeSize;
    protected int taggedNodeSize;
    protected Color currentColor;
    protected MapPath2D currentPath = new MapPath2D();
    private DataSet ds;
    private static final ArrowPaintHelper ARROW_PAINT_HELPER = new ArrowPaintHelper(Math.toRadians(20.0), 10.0);
    private final Stroke relatedWayStroke = new BasicStroke(4.0f, 2, 2);
    private MapViewState.MapViewRectangle viewClip;

    public WireframeMapRenderer(Graphics2D graphics2D, NavigatableComponent navigatableComponent, boolean bl) {
        super(graphics2D, navigatableComponent, bl);
    }

    @Override
    public void getColors() {
        super.getColors();
        this.dfltWayColor = PaintColors.DEFAULT_WAY.get();
        this.relationColor = PaintColors.RELATION.get();
        this.untaggedWayColor = PaintColors.UNTAGGED_WAY.get();
        this.highlightColor = PaintColors.HIGHLIGHT_WIREFRAME.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = !this.taggedColor.equals(this.nodeColor) ? this.taggedColor : this.connectionColor;
    }

    @Override
    protected void getSettings(boolean bl) {
        super.getSettings(bl);
        MapPaintSettings mapPaintSettings = MapPaintSettings.INSTANCE;
        this.showDirectionArrow = mapPaintSettings.isShowDirectionArrow();
        this.showOnewayArrow = mapPaintSettings.isShowOnewayArrow();
        this.showHeadArrowOnly = mapPaintSettings.isShowHeadArrowOnly();
        this.showOrderNumber = mapPaintSettings.isShowOrderNumber();
        this.selectedNodeSize = mapPaintSettings.getSelectedNodeSize();
        this.unselectedNodeSize = mapPaintSettings.getUnselectedNodeSize();
        this.connectionNodeSize = mapPaintSettings.getConnectionNodeSize();
        this.taggedNodeSize = mapPaintSettings.getTaggedNodeSize();
        this.fillSelectedNode = mapPaintSettings.isFillSelectedNode();
        this.fillUnselectedNode = mapPaintSettings.isFillUnselectedNode();
        this.fillConnectionNode = mapPaintSettings.isFillConnectionNode();
        this.fillTaggedNode = mapPaintSettings.isFillTaggedNode();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.wireframe.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void render(DataSet dataSet, boolean bl, Bounds bounds) {
        BBox bBox = bounds.toBBox();
        this.ds = dataSet;
        Rectangle rectangle = this.g.getClipBounds();
        rectangle.grow(50, 50);
        this.viewClip = this.mapState.getViewArea(rectangle);
        this.getSettings(bl);
        for (Relation object22 : dataSet.searchRelations(bBox)) {
            if (!object22.isDrawable() || this.ds.isSelected(object22) || object22.isDisabledAndHidden()) continue;
            object22.accept(this);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        for (Way way : dataSet.searchWays(bBox)) {
            if (!way.isDrawable() || this.ds.isSelected(way) || way.isDisabledAndHidden()) continue;
            if (way.isHighlighted()) {
                arrayList.add(way);
                continue;
            }
            if (!way.isTagged()) {
                arrayList2.add(way);
                continue;
            }
            way.accept(this);
        }
        this.displaySegments();
        ArrayList arrayList3 = new ArrayList(arrayList2);
        arrayList3.addAll(arrayList);
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            Way way = (Way)iterator.next();
            way.accept(this);
        }
        arrayList3.clear();
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : dataSet.getSelected()) {
            if (!osmPrimitive.isDrawable()) continue;
            osmPrimitive.accept(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : dataSet.searchNodes(bBox)) {
            if (!osmPrimitive.isDrawable() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isDisabledAndHidden()) continue;
            osmPrimitive.accept(this);
        }
        this.drawVirtualNodes(dataSet, bBox);
        for (WaySegment waySegment : dataSet.getHighlightedWaySegments()) {
            this.drawSegment(this.mapState.getPointFor(waySegment.getFirstNode()), this.mapState.getPointFor(waySegment.getSecondNode()), this.highlightColor, false);
        }
        this.displaySegments();
    }

    private static int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    @Override
    public void visit(Node node) {
        if (node.isIncomplete()) {
            return;
        }
        if (node.isHighlighted()) {
            this.drawNode(node, this.highlightColor, this.selectedNodeSize, this.fillSelectedNode);
        } else {
            Color color = this.isInactiveMode || node.isDisabled() ? this.inactiveColor : (node.isSelected() ? this.selectedColor : (node.isMemberOfSelected() ? this.relationSelectedColor : (node.isConnectionNode() ? (WireframeMapRenderer.isNodeTagged(node) ? this.taggedConnectionColor : this.connectionColor) : (WireframeMapRenderer.isNodeTagged(node) ? this.taggedColor : this.nodeColor))));
            int n = WireframeMapRenderer.max(this.ds.isSelected(node) ? this.selectedNodeSize : 0, WireframeMapRenderer.isNodeTagged(node) ? this.taggedNodeSize : 0, node.isConnectionNode() ? this.connectionNodeSize : 0, this.unselectedNodeSize);
            boolean bl = this.ds.isSelected(node) && this.fillSelectedNode || WireframeMapRenderer.isNodeTagged(node) && this.fillTaggedNode || node.isConnectionNode() && this.fillConnectionNode || this.fillUnselectedNode;
            this.drawNode(node, color, n, bl);
        }
    }

    private static boolean isNodeTagged(Node node) {
        return node.isTagged() || node.isAnnotated();
    }

    @Override
    public void visit(Way way) {
        boolean bl;
        if (way.isIncomplete() || way.getNodesCount() < 2) {
            return;
        }
        boolean bl2 = this.ds.isSelected(way) || this.showDirectionArrow;
        boolean bl3 = bl = bl2 && !this.ds.isSelected(way) && this.showHeadArrowOnly;
        Color color = this.isInactiveMode || way.isDisabled() ? this.inactiveColor : (way.isHighlighted() ? this.highlightColor : (way.isSelected() ? this.selectedColor : (way.isMemberOfSelected() ? this.relationSelectedColor : (!way.isTagged() ? this.untaggedWayColor : this.dfltWayColor))));
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(iterator.next());
            int n = mapViewPoint.getOutsideRectangleFlags(this.viewClip);
            int n2 = 1;
            while (iterator.hasNext()) {
                MapViewState.MapViewPoint mapViewPoint2 = this.mapState.getPointFor(iterator.next());
                int n3 = mapViewPoint2.getOutsideRectangleFlags(this.viewClip);
                if ((n3 & n) == 0) {
                    this.drawSegment(mapViewPoint, mapViewPoint2, color, bl ? !iterator.hasNext() : bl2);
                    if (this.showOrderNumber && !this.isInactiveMode) {
                        this.drawOrderNumber(mapViewPoint, mapViewPoint2, n2, this.g.getColor());
                    }
                }
                mapViewPoint = mapViewPoint2;
                n = n3;
                ++n2;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isIncomplete()) {
            return;
        }
        Color color = this.isInactiveMode || relation.isDisabled() ? this.inactiveColor : (relation.isSelected() ? this.selectedColor : (relation.isMultipolygon() && relation.isMemberOfSelected() ? this.relationSelectedColor : this.relationColor));
        this.g.setColor(color);
        for (RelationMember relationMember : relation.getMembers()) {
            Object object;
            if (relationMember.getMember().isIncomplete() || !relationMember.getMember().isDrawable()) continue;
            if (relationMember.isNode()) {
                object = this.mapState.getPointFor(relationMember.getNode());
                if (!((MapViewState.MapViewPoint)object).isInView()) continue;
                this.g.draw(new Ellipse2D.Double(((MapViewState.MapViewPoint)object).getInViewX() - 4.0, ((MapViewState.MapViewPoint)object).getInViewY() - 4.0, 9.0, 9.0));
                continue;
            }
            if (!relationMember.isWay()) continue;
            object = new GeneralPath();
            boolean bl = true;
            for (Node node : relationMember.getWay().getNodes()) {
                if (!node.isDrawable()) continue;
                MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(node);
                if (bl) {
                    ((Path2D.Float)object).moveTo(mapViewPoint.getInViewX(), mapViewPoint.getInViewY());
                    bl = false;
                    continue;
                }
                ((Path2D.Float)object).lineTo(mapViewPoint.getInViewX(), mapViewPoint.getInViewY());
            }
            this.g.draw(this.relatedWayStroke.createStrokedShape((Shape)object));
        }
    }

    @Override
    public void visit(Changeset changeset) {
    }

    @Override
    public void drawNode(Node node, Color color, int n, boolean bl) {
        if (n > 1) {
            MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(node);
            if (!mapViewPoint.isInView()) {
                return;
            }
            int n2 = n / 2;
            Rectangle2D.Double double_ = new Rectangle2D.Double(mapViewPoint.getInViewX() - (double)n2, mapViewPoint.getInViewY() - (double)n2, n, n);
            this.g.setColor(color);
            if (bl) {
                this.g.fill(double_);
            }
            this.g.draw(double_);
        }
    }

    protected void drawSegment(MapPath2D mapPath2D, MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2, boolean bl) {
        mapPath2D.moveTo(mapViewPoint);
        mapPath2D.lineTo(mapViewPoint2);
        if (bl) {
            ARROW_PAINT_HELPER.paintArrowAt(mapPath2D, mapViewPoint2, mapViewPoint);
        }
    }

    protected void drawSegment(MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2, Color color, boolean bl) {
        if (!color.equals(this.currentColor)) {
            this.displaySegments(color);
        }
        this.drawSegment(this.currentPath, mapViewPoint, mapViewPoint2, bl);
    }

    protected void displaySegments() {
        this.displaySegments(null);
    }

    protected void displaySegments(Color color) {
        if (this.currentPath != null) {
            this.g.setColor(this.currentColor);
            this.g.draw(this.currentPath);
            this.currentPath = new MapPath2D();
            this.currentColor = color;
        }
    }
}

