/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Locale;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.builtins.PrimitiveNode;
import org.jruby.truffle.core.cast.DefaultValueNodeGen;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.numeric.GeneralDivModNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.util.DoubleUtils;
import org.jruby.truffle.util.StringUtils;

@CoreClass(value="Float")
public abstract class FloatNodes {

    @Primitive(name="float_signbit_p")
    public static abstract class FloatSignBitNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public boolean floatSignBit(double value) {
            return Double.doubleToLongBits(value) >>> 63 == 1L;
        }
    }

    @Primitive(name="float_dtoa")
    public static abstract class FloatDToAPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject dToA(double value) {
            int decimal;
            String string = StringUtils.format(Locale.ENGLISH, "%.1022f", value);
            if (string.toLowerCase(Locale.ENGLISH).contains("e")) {
                throw new UnsupportedOperationException();
            }
            string = StringUtils.replace(string, "-", "");
            while (string.charAt(string.length() - 1) == '0') {
                string = string.substring(0, string.length() - 1);
            }
            if (string.startsWith("0.")) {
                string = StringUtils.replace(string, "0.", "");
                decimal = 0;
                while (string.charAt(0) == '0') {
                    string = string.substring(1, string.length());
                    --decimal;
                }
            } else {
                decimal = string.indexOf(46);
                if (decimal == -1) {
                    throw new UnsupportedOperationException();
                }
                string = StringUtils.replace(string, ".", "");
            }
            int sign = value < 0.0 ? 1 : 0;
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{this.create7BitString(string, (Encoding)UTF8Encoding.INSTANCE), decimal, sign, string.length()}, 4);
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(double value) {
            int i;
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                return this.create7BitString(DoubleUtils.toString(value), (Encoding)USASCIIEncoding.INSTANCE);
            }
            String str = StringUtils.format(Locale.ENGLISH, "%.15g", value);
            if (str.indexOf(46) == -1) {
                assert (str.indexOf(101) == -1);
                str = str + ".0";
            }
            int dot = str.indexOf(46);
            assert (dot != -1);
            int e = str.indexOf(101);
            boolean hasE = e != -1;
            int start = hasE ? e : str.length();
            for (i = start - 1; i > dot + 1 && str.charAt(i) == '0'; --i) {
            }
            String formatted = str.substring(0, i + 1) + str.substring(start, str.length());
            return this.create7BitString(formatted, (Encoding)USASCIIEncoding.INSTANCE);
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double toF(double value) {
            return value;
        }
    }

    @CoreMethod(names={"to_i", "to_int", "truncate"})
    public static abstract class ToINode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public abstract Object executeToI(VirtualFrame var1, double var2);

        @Specialization
        Object toI(double value, @Cached(value="create()") BranchProfile errorProfile) {
            if (Double.isInfinite(value)) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(value)) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().floatDomainError("NaN", this));
            }
            return this.fixnumOrBignum.fixnumOrBignum(value);
        }
    }

    @Primitive(name="float_round", lowerFixnum={1})
    @NodeChildren(value={@NodeChild(value="n", type=RubyNode.class), @NodeChild(value="ndigits", type=RubyNode.class)})
    public static abstract class FloatRoundPrimitiveNode
    extends PrimitiveNode {
        @CreateCast(value={"ndigits"})
        public RubyNode coerceDefault(RubyNode ndigits) {
            return DefaultValueNodeGen.create(null, null, 0, ndigits);
        }

        @Specialization(guards={"ndigits == 0", "doubleInIntRange(n)"})
        public int roundFittingInt(double n, int ndigits, @Cached(value="createBinaryProfile()") ConditionProfile positiveProfile) {
            int l = (int)n;
            if (positiveProfile.profile(n >= 0.0)) {
                if (n - (double)l >= 0.5) {
                    ++l;
                }
                return l;
            }
            if ((double)l - n >= 0.5) {
                --l;
            }
            return l;
        }

        protected boolean doubleInIntRange(double n) {
            return -2.147483648E9 < n && n < 2.147483647E9;
        }

        @Specialization(guards={"ndigits == 0", "doubleInLongRange(n)"}, contains={"roundFittingInt"})
        public long roundFittingLong(double n, int ndigits, @Cached(value="createBinaryProfile()") ConditionProfile positiveProfile) {
            long l = (long)n;
            if (positiveProfile.profile(n >= 0.0)) {
                if (n - (double)l >= 0.5) {
                    ++l;
                }
                return l;
            }
            if ((double)l - n >= 0.5) {
                --l;
            }
            return l;
        }

        protected boolean doubleInLongRange(double n) {
            return -9.223372036854776E18 < n && n < 9.223372036854776E18;
        }

        @Specialization(guards={"ndigits == 0"}, contains={"roundFittingLong"})
        public Object round(double n, int ndigits, @Cached(value="createBinaryProfile()") ConditionProfile positiveProfile, @Cached(value="create()") BranchProfile errorProfile, @Cached(value="new()") FixnumOrBignumNode fixnumOrBignum) {
            if (Double.isInfinite(n)) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(n)) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().floatDomainError("NaN", this));
            }
            double f = n;
            if (positiveProfile.profile(f >= 0.0)) {
                if (n - (f = Math.floor(f)) >= 0.5) {
                    f += 1.0;
                }
            } else if ((f = Math.ceil(f)) - n >= 0.5) {
                f -= 1.0;
            }
            return fixnumOrBignum.fixnumOrBignum(f);
        }

        @Specialization(guards={"ndigits != 0"})
        public Object roundDigits(double n, int ndigits) {
            return null;
        }

        @Specialization(guards={"!isInteger(ndigits)"})
        public Object roundFallback(double n, Object ndigits) {
            return null;
        }
    }

    @CoreMethod(names={"prev_float"})
    public static abstract class PrevFloatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double prevFloat(double value) {
            return Math.nextDown(value);
        }
    }

    @CoreMethod(names={"next_float"})
    public static abstract class NextFloatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double nextFloat(double value) {
            return Math.nextUp(value);
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NaNNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean nan(double value) {
            return Double.isNaN(value);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object infinite(double value) {
            if (Double.isInfinite(value)) {
                if (value < 0.0) {
                    return -1;
                }
                return 1;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"floor"})
    public static abstract class FloorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public FloorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @Specialization
        public Object floor(double n) {
            return this.fixnumOrBignum.fixnumOrBignum(Math.floor(n));
        }
    }

    @CoreMethod(names={"ceil"})
    public static abstract class CeilNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public CeilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @Specialization
        public Object ceil(double n) {
            return this.fixnumOrBignum.fixnumOrBignum(Math.ceil(n));
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double abs(double n) {
            return Math.abs(n);
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean greater(double a, long b) {
            return a > (double)b;
        }

        @Specialization
        public boolean greater(double a, double b) {
            return a > b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(double a, DynamicObject b) {
            return a > Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterCoerced(VirtualFrame frame, double a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce(other, :compare_error); a > b", "other", b);
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean greaterEqual(double a, long b) {
            return a >= (double)b;
        }

        @Specialization
        public boolean greaterEqual(double a, double b) {
            return a >= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(double a, DynamicObject b) {
            return a >= Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterEqualCoerced(VirtualFrame frame, double a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a >= b", "other", b);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNaN(a)"})
        public DynamicObject compareFirstNaN(double a, Object b) {
            return this.nil();
        }

        @Specialization(guards={"isNaN(b)"})
        public DynamicObject compareSecondNaN(Object a, double b) {
            return this.nil();
        }

        @Specialization(guards={"!isNaN(a)"})
        public int compare(double a, long b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"isInfinity(a)", "isRubyBignum(b)"})
        public int compareInfinity(double a, DynamicObject b) {
            if (a < 0.0) {
                return -1;
            }
            return 1;
        }

        @Specialization(guards={"!isNaN(a)", "!isInfinity(a)", "isRubyBignum(b)"})
        public int compareBignum(double a, DynamicObject b) {
            return Double.compare(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization(guards={"!isNaN(a)", "!isNaN(b)"})
        public int compare(double a, double b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"!isNaN(a)", "!isRubyBignum(b)"})
        public DynamicObject compare(double a, DynamicObject b) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;

        @Specialization
        public boolean equal(double a, long b) {
            return a == (double)b;
        }

        @Specialization
        public boolean equal(double a, double b) {
            return a == b;
        }

        @Specialization
        public boolean equal(double a, boolean b) {
            return false;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(double a, DynamicObject b) {
            return a == Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object equal(VirtualFrame frame, double a, DynamicObject b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fallbackCallNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.fallbackCallNode.call(frame, a, "equal_fallback", b);
        }
    }

    @CoreMethod(names={"eql?"}, required=1)
    public static abstract class EqlNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean eql(double a, double b) {
            return a == b;
        }

        @Specialization(guards={"!isDouble(b)"})
        public boolean eqlGeneral(double a, Object b) {
            return false;
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean lessEqual(double a, long b) {
            return a <= (double)b;
        }

        @Specialization
        public boolean lessEqual(double a, double b) {
            return a <= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(double a, DynamicObject b) {
            return a <= Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessEqualCoerced(VirtualFrame frame, double a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a <= b", "other", b);
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean less(double a, long b) {
            return a < (double)b;
        }

        @Specialization
        public boolean less(double a, double b) {
            return a < b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessBignum(double a, DynamicObject b) {
            return a < Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessCoerced(VirtualFrame frame, double a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        @Specialization
        public DynamicObject divMod(double a, long b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public DynamicObject divMod(double a, double b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public DynamicObject divMod(double a, DynamicObject b) {
            return this.divModNode.execute(a, Layouts.BIGNUM.getValue(b));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object divModCoerced(VirtualFrame frame, double a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :divmod, b", "b", b);
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile lessThanZeroProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile zeroProfile = BranchProfile.create();

        @Specialization
        public double mod(double a, long b) {
            return this.mod(a, (double)b);
        }

        @Specialization
        public double mod(double a, double b) {
            if (b == 0.0) {
                this.zeroProfile.enter();
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            double result = Math.IEEEremainder(a, b);
            if (this.lessThanZeroProfile.profile(b * result < 0.0)) {
                result += b;
            }
            return result;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double mod(double a, DynamicObject b) {
            return this.mod(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object modCoerced(VirtualFrame frame, double a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :mod, b", "b", b);
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode redoCoercedNode;

        @Specialization
        public double div(double a, long b) {
            return a / (double)b;
        }

        @Specialization
        public double div(double a, double b) {
            return a / b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double div(double a, DynamicObject b) {
            return a / Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isDouble(b)", "!isRubyBignum(b)"})
        public Object div(VirtualFrame frame, double a, Object b) {
            if (this.redoCoercedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.redoCoercedNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.redoCoercedNode.call(frame, a, "redo_coerced", this.getSymbol("/"), b);
        }
    }

    @CoreMethod(names={"**"}, required=1)
    public static abstract class PowNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode complexConvertNode;
        @Node.Child
        private CallDispatchHeadNode complexPowNode;
        private final ConditionProfile complexProfile = ConditionProfile.createBinaryProfile();

        @Specialization(guards={"exponent == cachedExponent", "cachedExponent >= 0", "cachedExponent < 10"}, limit="10")
        @ExplodeLoop
        public double powCached(double base, long exponent, @Cached(value="exponent") long cachedExponent) {
            double result = 1.0;
            int i = 0;
            while ((long)i < cachedExponent) {
                result *= base;
                ++i;
            }
            return result;
        }

        @Specialization(contains={"powCached"})
        public double pow(double a, long b) {
            return Math.pow(a, b);
        }

        @Specialization
        public Object pow(VirtualFrame frame, double a, double b) {
            if (this.complexProfile.profile(a < 0.0 && b != (double)Math.round(b))) {
                if (this.complexConvertNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.complexConvertNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                    this.complexPowNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                Object aComplex = this.complexConvertNode.call(frame, this.coreLibrary().getComplexClass(), "convert", a, 0);
                return this.complexPowNode.call(frame, aComplex, "**", b);
            }
            return Math.pow(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double pow(double a, DynamicObject b) {
            return Math.pow(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object powCoerced(VirtualFrame frame, double a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :**, b", "b", b);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double mul(double a, long b) {
            return a * (double)b;
        }

        @Specialization
        public double mul(double a, double b) {
            return a * b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double mul(double a, DynamicObject b) {
            return a * Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object mulCoerced(VirtualFrame frame, double a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :*, b", "b", b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double sub(double a, long b) {
            return a - (double)b;
        }

        @Specialization
        public double sub(double a, double b) {
            return a - b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double sub(double a, DynamicObject b) {
            return a - Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object subCoerced(VirtualFrame frame, double a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :-, b", "b", b);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double add(double a, long b) {
            return a + (double)b;
        }

        @Specialization
        public double add(double a, double b) {
            return a + b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double add(double a, DynamicObject b) {
            return a + Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object addCoerced(VirtualFrame frame, double a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :+, b", "b", b);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double neg(double value) {
            return -value;
        }
    }
}

