/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.RopeOperations;

public abstract class Rope {
    private final Encoding encoding;
    private final CodeRange codeRange;
    private final boolean singleByteOptimizable;
    private final int byteLength;
    private final int characterLength;
    private final int ropeDepth;
    private int hashCode = 0;
    protected byte[] bytes;

    protected Rope(Encoding encoding, CodeRange codeRange, boolean singleByteOptimizable, int byteLength, int characterLength, int ropeDepth, byte[] bytes) {
        assert (encoding != null);
        this.encoding = encoding;
        this.codeRange = codeRange;
        this.singleByteOptimizable = singleByteOptimizable;
        this.byteLength = byteLength;
        this.characterLength = characterLength;
        this.ropeDepth = ropeDepth;
        this.bytes = bytes;
    }

    public abstract Rope withEncoding(Encoding var1, CodeRange var2);

    public final int characterLength() {
        return this.characterLength;
    }

    public final int byteLength() {
        return this.byteLength;
    }

    public final boolean isEmpty() {
        return this.byteLength == 0;
    }

    protected abstract byte getByteSlow(int var1);

    public final byte[] getRawBytes() {
        return this.bytes;
    }

    public final byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = RopeOperations.flattenBytes(this);
        }
        return this.bytes;
    }

    public final byte[] getBytesCopy() {
        return (byte[])this.getBytes().clone();
    }

    public final Encoding getEncoding() {
        return this.encoding;
    }

    public final CodeRange getCodeRange() {
        return this.codeRange;
    }

    public final boolean isSingleByteOptimizable() {
        return this.singleByteOptimizable;
    }

    public final int depth() {
        return this.ropeDepth;
    }

    public final int hashCode() {
        if (!this.isHashCodeCalculated()) {
            this.hashCode = RopeOperations.hashForRange(this, 1, 0, this.byteLength);
        }
        return this.hashCode;
    }

    public final boolean isHashCodeCalculated() {
        return this.hashCode != 0;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Rope) {
            Rope other = (Rope)o;
            if (this.isHashCodeCalculated() && other.isHashCodeCalculated() && this.hashCode != other.hashCode) {
                return false;
            }
            return this.byteLength() == other.byteLength() && Arrays.equals(this.getBytes(), other.getBytes());
        }
        return false;
    }

    public byte get(int index) {
        if (this.bytes != null) {
            return this.bytes[index];
        }
        return this.getByteSlow(index);
    }
}

