/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class BoundedList<E>
extends AbstractList<E> {
    private final E leftBoundary;
    private final E rightBoundary;
    private final List<E> list;

    @Override
    public E get(int index) {
        if (index < 0) {
            return this.leftBoundary;
        }
        if (index >= this.list.size()) {
            return this.rightBoundary;
        }
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public BoundedList(List<E> list, E leftBoundary, E rightBoundary) {
        this.list = list;
        this.leftBoundary = leftBoundary;
        this.rightBoundary = rightBoundary;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ArrayList<E> retVal = new ArrayList<E>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            retVal.add(this.get(i));
        }
        return retVal;
    }
}

