/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.query.enumerate.EnumerationQuery;
import org.encog.ml.bayesian.table.TableLine;

public class BayesianTable
implements Serializable {
    private final BayesianEvent event;
    private final List<TableLine> lines = new ArrayList<TableLine>();

    public BayesianTable(BayesianEvent theEvent) {
        this.event = theEvent;
        this.reset();
    }

    public void reset() {
        this.lines.clear();
        List<BayesianEvent> parents = this.event.getParents();
        int l = parents.size();
        int[] args = new int[l];
        do {
            for (int k = 0; k < this.event.getChoices().size(); ++k) {
                this.addLine(0.0, k, args);
            }
        } while (EnumerationQuery.roll(parents, args));
    }

    public void addLine(double prob, boolean result, boolean ... args) {
        int[] d = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            d[i] = args[i] ? 0 : 1;
        }
        this.addLine(prob, result ? 0 : 1, d);
        this.addLine(1.0 - prob, result ? 1 : 0, d);
    }

    public void addLine(double prob, int result, boolean ... args) {
        int[] d = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            d[i] = args[i] ? 0 : 1;
        }
        this.addLine(prob, result, d);
    }

    public void addLine(double prob, int result, int ... args) {
        if (args.length != this.event.getParents().size()) {
            throw new BayesianError("Truth table line with " + args.length + ", specied for event with " + this.event.getParents().size() + " parents.  These numbers must be the same");
        }
        TableLine line = this.findLine(result, args);
        if (line == null) {
            if (this.lines.size() == this.getMaxLines()) {
                throw new BayesianError("This truth table is already full.");
            }
            line = new TableLine(prob, result, args);
            this.lines.add(line);
        } else {
            line.setProbability(prob);
        }
    }

    public void validate() {
        if (this.lines.size() != this.getMaxLines()) {
            throw new BayesianError("Truth table for " + this.event.toString() + " only has " + this.lines + " line(s), should have " + this.getMaxLines() + " line(s).");
        }
    }

    public int generateRandom(int ... args) {
        double r = Math.random();
        double limit = 0.0;
        for (TableLine line : this.lines) {
            if (line == null || !line.compareArgs(args) || !(r < (limit += line.getProbability()))) continue;
            return line.getResult();
        }
        throw new BayesianError("Incomplete logic table for event: " + this.event.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (TableLine line : this.lines) {
            result.append(line.toString());
            result.append("\n");
        }
        return result.toString();
    }

    public List<TableLine> getLines() {
        return this.lines;
    }

    public TableLine findLine(int result, int[] args) {
        for (TableLine line : this.lines) {
            if (line == null || !line.compareArgs(args) || !((double)Math.abs(line.getResult() - result) < 1.0E-13)) continue;
            return line;
        }
        return null;
    }

    public int getMaxLines() {
        return this.event.calculateParameterCount() * this.event.getChoices().size();
    }
}

