/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.graph;

import java.util.ArrayList;
import java.util.List;
import org.encog.EncogError;
import org.encog.ml.graph.BasicEdge;

public class BasicNode {
    private final List<BasicEdge> connections = new ArrayList<BasicEdge>();
    private final List<BasicEdge> backConnections = new ArrayList<BasicEdge>();
    private final String label;

    public BasicNode(String label) {
        this.label = label;
    }

    public List<BasicEdge> getConnections() {
        return this.connections;
    }

    public String getLabel() {
        return this.label;
    }

    public void connect(BasicNode newNode, double cost) {
        BasicEdge edge = new BasicEdge(this, newNode, cost);
        this.connections.add(edge);
        newNode.getBackConnections().add(edge);
    }

    public List<BasicEdge> getBackConnections() {
        return this.backConnections;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[BasicNode: ");
        result.append(this.label);
        result.append("]");
        return result.toString();
    }

    public double getCost(BasicNode node) {
        for (BasicEdge edge : this.connections) {
            if (!edge.getTo().equals(node)) continue;
            return edge.getCost();
        }
        throw new EncogError("Nodes are not connected");
    }
}

