/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.svm;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;
import org.encog.mathutil.libsvm.svm;
import org.encog.mathutil.libsvm.svm_model;
import org.encog.ml.svm.SVM;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.persist.PersistError;

public class PersistSVM
implements EncogPersistor {
    public static final String PARAM_C = "C";
    public static final String PARAM_CACHE_SIZE = "cacheSize";
    public static final String PARAM_COEF0 = "coef0";
    public static final String PARAM_DEGREE = "degree";
    public static final String PARAM_EPS = "eps";
    public static final String PARAM_GAMMA = "gamma";
    public static final String PARAM_KERNEL_TYPE = "kernelType";
    public static final String PARAM_NUM_WEIGHT = "nrWeight";
    public static final String PARAM_NU = "nu";
    public static final String PARAM_P = "p";
    public static final String PARAM_PROBABILITY = "probability";
    public static final String PARAM_SHRINKING = "shrinking";
    public static final String PARAM_SVM_TYPE = "svmType";
    public static final String PARAM_WEIGHT = "weight";
    public static final String PARAM_WEIGHT_LABEL = "weightLabel";

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getPersistClassString() {
        return SVM.class.getSimpleName();
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        SVM result = new SVM();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("SVM") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (section.getSectionName().equals("SVM") && section.getSubSectionName().equals("SVM-PARAM")) {
                params = section.parseParams();
                result.setInputCount(EncogFileSection.parseInt(params, "inputCount"));
                result.getParams().C = EncogFileSection.parseDouble(params, PARAM_C);
                result.getParams().cache_size = EncogFileSection.parseDouble(params, PARAM_CACHE_SIZE);
                result.getParams().coef0 = EncogFileSection.parseDouble(params, PARAM_COEF0);
                result.getParams().degree = EncogFileSection.parseInt(params, PARAM_DEGREE);
                result.getParams().eps = EncogFileSection.parseDouble(params, PARAM_EPS);
                result.getParams().gamma = EncogFileSection.parseDouble(params, PARAM_GAMMA);
                result.getParams().kernel_type = EncogFileSection.parseInt(params, PARAM_KERNEL_TYPE);
                result.getParams().nr_weight = EncogFileSection.parseInt(params, PARAM_NUM_WEIGHT);
                result.getParams().nu = EncogFileSection.parseDouble(params, PARAM_NU);
                result.getParams().p = EncogFileSection.parseDouble(params, PARAM_P);
                result.getParams().probability = EncogFileSection.parseInt(params, PARAM_PROBABILITY);
                result.getParams().shrinking = EncogFileSection.parseInt(params, PARAM_SHRINKING);
                result.getParams().svm_type = EncogFileSection.parseInt(params, PARAM_SVM_TYPE);
                result.getParams().weight = section.parseDoubleArray(params, PARAM_WEIGHT);
                result.getParams().weight_label = EncogFileSection.parseIntArray(params, PARAM_WEIGHT_LABEL);
                continue;
            }
            if (!section.getSectionName().equals("SVM") || !section.getSubSectionName().equals("SVM-MODEL")) continue;
            try {
                StringReader rdr = new StringReader(section.getLinesAsString());
                BufferedReader br = new BufferedReader(rdr);
                svm_model model = svm.svm_load_model(br);
                result.setModel(model);
                br.close();
                rdr.close();
            }
            catch (IOException ex) {
                throw new PersistError(ex);
            }
        }
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        SVM svm2 = (SVM)obj;
        out.addSection("SVM");
        out.addSubSection("PARAMS");
        out.addProperties(svm2.getProperties());
        out.addSubSection("SVM-PARAM");
        out.writeProperty("inputCount", svm2.getInputCount());
        out.writeProperty(PARAM_C, svm2.getParams().C);
        out.writeProperty(PARAM_CACHE_SIZE, svm2.getParams().cache_size);
        out.writeProperty(PARAM_COEF0, svm2.getParams().coef0);
        out.writeProperty(PARAM_DEGREE, svm2.getParams().degree);
        out.writeProperty(PARAM_EPS, svm2.getParams().eps);
        out.writeProperty(PARAM_GAMMA, svm2.getParams().gamma);
        out.writeProperty(PARAM_KERNEL_TYPE, svm2.getParams().kernel_type);
        out.writeProperty(PARAM_NUM_WEIGHT, svm2.getParams().nr_weight);
        out.writeProperty(PARAM_NU, svm2.getParams().nu);
        out.writeProperty(PARAM_P, svm2.getParams().p);
        out.writeProperty(PARAM_PROBABILITY, svm2.getParams().probability);
        out.writeProperty(PARAM_SHRINKING, svm2.getParams().shrinking);
        out.writeProperty(PARAM_SVM_TYPE, svm2.getParams().svm_type);
        out.writeProperty(PARAM_WEIGHT, svm2.getParams().weight);
        out.writeProperty(PARAM_WEIGHT_LABEL, svm2.getParams().weight_label);
        if (svm2.getModel() != null) {
            out.addSubSection("SVM-MODEL");
            try {
                ByteArrayOutputStream ba = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(ba);
                svm.svm_save_model(das, svm2.getModel());
                out.write(ba.toString("UTF-8"));
                das.close();
                ba.close();
            }
            catch (IOException ex) {
                throw new PersistError(ex);
            }
        }
        out.flush();
    }
}

