/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.bam;

import org.encog.mathutil.matrices.Matrix;
import org.encog.ml.BasicML;
import org.encog.ml.data.MLData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.NeuralDataMapping;

public class BAM
extends BasicML {
    private static final long serialVersionUID = 1L;
    private int f1Count;
    private int f2Count;
    private Matrix weightsF1toF2;
    private Matrix weightsF2toF1;

    public BAM() {
    }

    public BAM(int theF1Count, int theF2Count) {
        this.f1Count = theF1Count;
        this.f2Count = theF2Count;
        this.weightsF1toF2 = new Matrix(this.f1Count, this.f2Count);
        this.weightsF2toF1 = new Matrix(this.f2Count, this.f1Count);
    }

    public void addPattern(MLData inputPattern, MLData outputPattern) {
        for (int i = 0; i < this.f1Count; ++i) {
            for (int j = 0; j < this.f2Count; ++j) {
                int weight = (int)(inputPattern.getData(i) * outputPattern.getData(j));
                this.weightsF1toF2.add(i, j, weight);
                this.weightsF2toF1.add(j, i, weight);
            }
        }
    }

    public void clear() {
        this.weightsF1toF2.clear();
        this.weightsF2toF1.clear();
    }

    public MLData compute(MLData input) {
        throw new NeuralNetworkError("Compute on BasicNetwork cannot be used, rather call the compute(NeuralData) method on the BAMLogic.");
    }

    public NeuralDataMapping compute(NeuralDataMapping input) {
        boolean stable1 = true;
        boolean stable2 = true;
        do {
            stable1 = this.propagateLayer(this.weightsF1toF2, input.getFrom(), input.getTo());
            stable2 = this.propagateLayer(this.weightsF2toF1, input.getTo(), input.getFrom());
        } while (!stable1 && !stable2);
        return null;
    }

    public int getF1Count() {
        return this.f1Count;
    }

    public int getF2Count() {
        return this.f2Count;
    }

    private double getWeight(Matrix matrix, MLData input, int x, int y) {
        if (matrix.getRows() != input.size()) {
            return matrix.get(x, y);
        }
        return matrix.get(y, x);
    }

    public Matrix getWeightsF1toF2() {
        return this.weightsF1toF2;
    }

    public Matrix getWeightsF2toF1() {
        return this.weightsF2toF1;
    }

    private boolean propagateLayer(Matrix matrix, MLData input, MLData output) {
        int out = 0;
        boolean stable = true;
        for (int i = 0; i < output.size(); ++i) {
            int sum = 0;
            for (int j = 0; j < input.size(); ++j) {
                sum = (int)((double)sum + this.getWeight(matrix, input, i, j) * input.getData(j));
            }
            if (sum == 0 || (out = sum < 0 ? -1 : 1) == (int)output.getData(i)) continue;
            stable = false;
            output.setData(i, out);
        }
        return stable;
    }

    public void setF1Count(int i) {
        this.f1Count = i;
    }

    public void setF2Count(int i) {
        this.f2Count = i;
    }

    public void setWeightsF1toF2(Matrix matrix) {
        this.weightsF1toF2 = matrix;
    }

    public void setWeightsF2toF1(Matrix matrix) {
        this.weightsF2toF1 = matrix;
    }

    @Override
    public void updateProperties() {
    }
}

