/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.expression.epl;

import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.parse.expression.CommonRender;
import org.encog.util.csv.CSVFormat;

public class RenderEPL
extends CommonRender {
    private EncogProgram program;

    public String render(EncogProgram theProgram) {
        this.program = theProgram;
        return this.renderNode(this.program.getRootNode());
    }

    private String renderNode(ProgramNode node) {
        int i;
        StringBuilder result = new StringBuilder();
        for (i = 0; i < node.getChildNodes().size(); ++i) {
            ProgramNode childNode = node.getChildNode(i);
            result.append(this.renderNode(childNode));
        }
        result.append('[');
        result.append(node.getName());
        result.append(':');
        result.append(node.getTemplate().getChildNodeCount());
        for (i = 0; i < node.getTemplate().getDataSize(); ++i) {
            result.append(':');
            ValueType t = node.getData()[i].getExpressionType();
            if (t == ValueType.booleanType) {
                result.append(node.getData()[i].toBooleanValue() ? (char)'t' : 'f');
                continue;
            }
            if (t == ValueType.floatingType) {
                result.append(CSVFormat.EG_FORMAT.format(node.getData()[i].toFloatValue(), 10));
                continue;
            }
            if (t == ValueType.intType) {
                result.append(node.getData()[i].toIntValue());
                continue;
            }
            if (t == ValueType.enumType) {
                result.append(node.getData()[i].getEnumType());
                result.append("#");
                result.append(node.getData()[i].toIntValue());
                continue;
            }
            if (t != ValueType.stringType) continue;
            result.append("\"");
            result.append(node.getData()[i].toStringValue());
            result.append("\"");
        }
        result.append(']');
        return result.toString().trim();
    }
}

