/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.tags.write;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.encog.EncogError;
import org.encog.neural.NeuralNetworkError;
import org.encog.parse.ParseError;

public class WriteTags {
    private final OutputStream output;
    private final Stack<String> tagStack;
    private final Map<String, String> attributes;

    public WriteTags(OutputStream output) {
        this.output = output;
        this.tagStack = new Stack();
        this.attributes = new HashMap<String, String>();
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void addCDATA(String text) {
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append("![CDATA[");
        builder.append(text);
        builder.append("]]");
        builder.append('>');
        try {
            this.output.write(builder.toString().getBytes());
        }
        catch (IOException e) {
            throw new ParseError(e);
        }
    }

    public void addProperty(String name, double d) {
        this.beginTag(name);
        this.addText("" + d);
        this.endTag();
    }

    public void addProperty(String name, int i) {
        this.addProperty(name, "" + i);
    }

    public void addProperty(String name, String str) {
        this.beginTag(name);
        this.addText(str);
        this.endTag();
    }

    public void addProperty(String name, double[] array, int len) {
        if (array != null) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    str.append(' ');
                }
                str.append(array[i]);
            }
            this.addProperty(name, str.toString());
        }
    }

    public void addProperty(String name, int[] array, int len) {
        if (array != null) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    str.append(' ');
                }
                str.append(array[i]);
            }
            this.addProperty(name, str.toString());
        }
    }

    public void addText(String text) {
        try {
            this.output.write(text.getBytes());
        }
        catch (IOException e) {
            throw new ParseError(e);
        }
    }

    public void beginDocument() {
    }

    public void beginTag(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(name);
        if (this.attributes.size() > 0) {
            for (String key : this.attributes.keySet()) {
                String value = this.attributes.get(key);
                builder.append(' ');
                builder.append(key);
                builder.append('=');
                builder.append("\"");
                builder.append(value);
                builder.append("\"");
            }
        }
        builder.append(">");
        try {
            this.output.write(builder.toString().getBytes());
        }
        catch (IOException e) {
            throw new ParseError(e);
        }
        this.attributes.clear();
        this.tagStack.push(name);
    }

    public void close() {
        try {
            this.output.close();
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }

    public void endDocument() {
    }

    public void endTag() {
        if (this.tagStack.isEmpty()) {
            throw new NeuralNetworkError("Can't create end tag, no beginning tag.");
        }
        String tag = this.tagStack.pop();
        StringBuilder builder = new StringBuilder();
        builder.append("</");
        builder.append(tag);
        builder.append(">");
        try {
            this.output.write(builder.toString().getBytes());
        }
        catch (IOException e) {
            throw new ParseError(e);
        }
    }

    public void endTag(String name) {
        if (!this.tagStack.peek().equals(name)) {
            throw new ParseError("End tag mismatch, should be ending: " + this.tagStack.peek() + ", but trying to end: " + name + ".");
        }
        this.endTag();
    }
}

