/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.util.HashMap;
import java.util.Map;
import org.encog.ca.universe.basic.PersistBasicUniverse;
import org.encog.ml.bayesian.PersistBayes;
import org.encog.ml.hmm.PersistHMM;
import org.encog.ml.prg.PersistPrgPopulation;
import org.encog.ml.svm.PersistSVM;
import org.encog.neural.art.PersistART1;
import org.encog.neural.bam.PersistBAM;
import org.encog.neural.cpn.PersistCPN;
import org.encog.neural.neat.PersistNEATPopulation;
import org.encog.neural.networks.PersistBasicNetwork;
import org.encog.neural.networks.training.propagation.PersistTrainingContinuation;
import org.encog.neural.pnn.PersistBasicPNN;
import org.encog.neural.rbf.PersistRBFNetwork;
import org.encog.neural.som.PersistSOM;
import org.encog.neural.thermal.PersistBoltzmann;
import org.encog.neural.thermal.PersistHopfield;
import org.encog.persist.EncogPersistor;

public final class PersistorRegistry {
    private static PersistorRegistry instance;
    private final Map<String, EncogPersistor> map = new HashMap<String, EncogPersistor>();

    public static PersistorRegistry getInstance() {
        if (instance == null) {
            instance = new PersistorRegistry();
        }
        return instance;
    }

    private PersistorRegistry() {
        this.add(new PersistSVM());
        this.add(new PersistHopfield());
        this.add(new PersistBoltzmann());
        this.add(new PersistART1());
        this.add(new PersistBAM());
        this.add(new PersistBasicNetwork());
        this.add(new PersistRBFNetwork());
        this.add(new PersistSOM());
        this.add(new PersistNEATPopulation());
        this.add(new PersistBasicPNN());
        this.add(new PersistCPN());
        this.add(new PersistTrainingContinuation());
        this.add(new PersistBayes());
        this.add(new PersistHMM());
        this.add(new PersistBasicUniverse());
        this.add(new PersistPrgPopulation());
    }

    public void add(EncogPersistor persistor) {
        this.map.put(persistor.getPersistClassString(), persistor);
    }

    public EncogPersistor getPersistor(Class<?> clazz) {
        return this.getPersistor(clazz.getSimpleName());
    }

    public EncogPersistor getPersistor(String name) {
        return this.map.get(name);
    }
}

