/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.util.Map;
import org.encog.EncogError;
import org.encog.util.csv.CSVFormat;

public class ParamsHolder {
    private final Map<String, String> params;
    private final CSVFormat format;

    public ParamsHolder(Map<String, String> theParams, CSVFormat theFormat) {
        this.params = theParams;
        this.format = theFormat;
    }

    public ParamsHolder(Map<String, String> theParams) {
        this(theParams, CSVFormat.EG_FORMAT);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getString(String name, boolean required, String defaultValue) {
        if (this.params.containsKey(name.toUpperCase())) {
            return this.params.get(name.toUpperCase());
        }
        if (required) {
            throw new EncogError("Missing property: " + name);
        }
        return defaultValue;
    }

    public int getInt(String name, boolean required, int defaultValue) {
        String str = this.getString(name, required, null);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            throw new EncogError("Property " + name + " has an invalid value of " + str + ", should be valid integer.");
        }
    }

    public double getDouble(String name, boolean required, double defaultValue) {
        String str = this.getString(name, required, null);
        if (str == null) {
            return defaultValue;
        }
        try {
            return this.format.parse(str);
        }
        catch (NumberFormatException ex) {
            throw new EncogError("Property " + name + " has an invalid value of " + str + ", should be valid floating point.");
        }
    }

    public boolean getBoolean(String name, boolean required, boolean defaultValue) {
        String str = this.getString(name, required, null);
        if (str == null) {
            return defaultValue;
        }
        if (!str.equalsIgnoreCase("true") && !str.equalsIgnoreCase("false")) {
            throw new EncogError("Property " + name + " has an invalid value of " + str + ", should be true/false.");
        }
        return str.equalsIgnoreCase("true");
    }
}

